/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Graph;
import org.tensorflow.Operand;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class Gradients
implements Iterable<Operand<?>> {
    private List<Output<?>> dy;

    public static Gradients create(Scope scope, Iterable<? extends Operand<?>> y, Iterable<? extends Operand<?>> x, Options ... options) {
        if (!(scope.env() instanceof Graph)) {
            throw new IllegalArgumentException("Gradients can be computed only in a graph execution environment");
        }
        Graph graph = (Graph)scope.env();
        Output<?>[] dx = null;
        if (options != null) {
            for (Options opts : options) {
                if (opts.dx == null) continue;
                dx = Operands.asOutputs(opts.dx);
            }
        }
        Output<?>[] dy = graph.addGradients(scope.makeOpName("Gradients"), Operands.asOutputs(y), Operands.asOutputs(x), dx);
        return new Gradients(Arrays.asList(dy));
    }

    public static Gradients create(Scope scope, Operand<?> y, Iterable<? extends Operand<?>> x, Options ... options) {
        return Gradients.create(scope, Collections.singletonList(y), x, options);
    }

    public static Options dx(Iterable<? extends Operand<?>> dx) {
        return new Options().dx(dx);
    }

    @Override
    public Iterator<Operand<?>> iterator() {
        return this.dy.iterator();
    }

    public List<Output<?>> dy() {
        return this.dy;
    }

    public <T extends TType> Output<T> dy(int index) {
        return this.dy.get(index);
    }

    private Gradients(List<Output<?>> dy) {
        this.dy = dy;
    }

    public static class Options {
        private Iterable<? extends Operand<?>> dx;

        public Options dx(Iterable<? extends Operand<?>> dx) {
            this.dx = dx;
            return this;
        }

        private Options() {
        }
    }
}

