/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.sparse;

import java.nio.ReadOnlyBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.tensorflow.ndarray.FloatNdArray;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.StdArrays;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.ndarray.buffer.FloatDataBuffer;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.ndarray.impl.sparse.AbstractSparseNdArray;
import org.tensorflow.ndarray.impl.sparse.slice.FloatSparseSlice;
import org.tensorflow.ndarray.index.Index;

public class FloatSparseNdArray
extends AbstractSparseNdArray<Float, FloatNdArray>
implements FloatNdArray {
    protected FloatSparseNdArray(LongNdArray indices, FloatNdArray values, float defaultValue, DimensionalSpace dimensions) {
        super(indices, values, Float.valueOf(defaultValue), dimensions);
    }

    FloatSparseNdArray(LongNdArray indices, FloatNdArray values, DimensionalSpace dimensions) {
        this(indices, values, 0.0f, dimensions);
    }

    FloatSparseNdArray(FloatDataBuffer dataBuffer, DimensionalSpace dimensions) {
        this(dataBuffer, 0.0f, dimensions);
    }

    FloatSparseNdArray(FloatDataBuffer dataBuffer, float defaultValue, DimensionalSpace dimensions) {
        super(Float.valueOf(defaultValue), dimensions);
        this.write(dataBuffer);
    }

    FloatSparseNdArray(DimensionalSpace dimensions) {
        this(0.0f, dimensions);
    }

    FloatSparseNdArray(float defaultValue, DimensionalSpace dimensions) {
        super(Float.valueOf(defaultValue), dimensions);
    }

    public static FloatSparseNdArray create(LongNdArray indices, FloatNdArray values, DimensionalSpace dimensions) {
        return new FloatSparseNdArray(indices, values, dimensions);
    }

    public static FloatSparseNdArray create(LongNdArray indices, FloatNdArray values, float defaultValue, DimensionalSpace dimensions) {
        return new FloatSparseNdArray(indices, values, defaultValue, dimensions);
    }

    public static FloatSparseNdArray create(FloatDataBuffer dataBuffer, DimensionalSpace dimensions) {
        return new FloatSparseNdArray(dataBuffer, dimensions);
    }

    public static FloatSparseNdArray create(FloatDataBuffer dataBuffer, float defaultValue, DimensionalSpace dimensions) {
        return new FloatSparseNdArray(dataBuffer, defaultValue, dimensions);
    }

    public static FloatSparseNdArray create(DimensionalSpace dimensions) {
        return new FloatSparseNdArray(dimensions);
    }

    public static FloatSparseNdArray create(float defaultValue, DimensionalSpace dimensions) {
        return new FloatSparseNdArray(defaultValue, dimensions);
    }

    public static FloatSparseNdArray create(FloatDataBuffer buffer, Shape shape) {
        return new FloatSparseNdArray(buffer, DimensionalSpace.create(shape));
    }

    public static FloatSparseNdArray create(FloatDataBuffer buffer, float defaultValue, Shape shape) {
        return new FloatSparseNdArray(buffer, defaultValue, DimensionalSpace.create(shape));
    }

    public static FloatSparseNdArray create(FloatNdArray src) {
        FloatDataBuffer buffer = DataBuffers.ofFloats(src.size());
        src.read(buffer);
        return new FloatSparseNdArray(buffer, DimensionalSpace.create(src.shape()));
    }

    public static FloatSparseNdArray create(FloatNdArray src, float defaultValue) {
        FloatDataBuffer buffer = DataBuffers.ofFloats(src.size());
        src.read(buffer);
        return new FloatSparseNdArray(buffer, defaultValue, DimensionalSpace.create(src.shape()));
    }

    @Override
    public FloatNdArray createValues(Shape shape) {
        return NdArrays.ofFloats(shape);
    }

    @Override
    public FloatNdArray slice(long position, DimensionalSpace sliceDimensions) {
        return new FloatSparseSlice(this, position, sliceDimensions);
    }

    @Override
    public float getFloat(long ... coordinates) {
        return ((Float)this.getObject(coordinates)).floatValue();
    }

    @Override
    public FloatNdArray setFloat(float value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatNdArray read(DataBuffer<Float> dst) {
        return this.read((FloatDataBuffer)dst);
    }

    @Override
    public FloatNdArray read(FloatDataBuffer dst) {
        Object[] defaults = new Float[(int)this.shape().size()];
        Arrays.fill(defaults, this.getDefaultValue());
        dst.write(defaults);
        AtomicInteger i = new AtomicInteger();
        this.getIndices().elements(0).forEachIndexed((idx, l) -> {
            long[] coordinates = this.getIndicesCoordinates((LongNdArray)l);
            float value = ((FloatNdArray)this.getValues()).getFloat(i.getAndIncrement());
            dst.setObject(Float.valueOf(value), this.dimensions.positionOf(coordinates));
        });
        return this;
    }

    @Override
    public FloatNdArray write(FloatDataBuffer src) {
        ArrayList<long[]> indices = new ArrayList<long[]>();
        ArrayList<Float> values = new ArrayList<Float>();
        for (long i = 0L; i < src.size(); ++i) {
            if (src.getObject(i).equals(this.getDefaultValue())) continue;
            indices.add(this.toCoordinates(this.dimensions, i));
            values.add(src.getObject(i));
        }
        long[][] indicesArray = new long[indices.size()][];
        float[] valuesArray = new float[values.size()];
        for (int i = 0; i < indices.size(); ++i) {
            indicesArray[i] = (long[])indices.get(i);
            valuesArray[i] = ((Float)values.get(i)).floatValue();
        }
        this.setIndices(StdArrays.ndCopyOf(indicesArray));
        this.setValues(NdArrays.vectorOf(valuesArray));
        return this;
    }

    @Override
    public FloatNdArray write(DataBuffer<Float> src) {
        return this.write((FloatDataBuffer)src);
    }

    @Override
    public FloatNdArray toDense() {
        FloatDataBuffer dataBuffer = DataBuffers.ofFloats(this.shape().size());
        this.read(dataBuffer);
        return NdArrays.wrap(this.shape(), dataBuffer);
    }

    public FloatNdArray fromDense(FloatNdArray src) {
        FloatDataBuffer buffer = DataBuffers.ofFloats(src.size());
        src.read(buffer);
        this.write(buffer);
        return this;
    }

    @Override
    public FloatNdArray slice(Index ... indices) {
        return (FloatNdArray)super.slice(indices);
    }

    @Override
    public FloatNdArray get(long ... coordinates) {
        return (FloatNdArray)super.get(coordinates);
    }

    @Override
    public FloatNdArray setObject(Float value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatNdArray set(NdArray<Float> src, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatNdArray copyTo(NdArray<Float> dst) {
        return (FloatNdArray)super.copyTo(dst);
    }

    @Override
    public FloatNdArray createDefaultArray() {
        return NdArrays.scalarOf(((Float)this.getDefaultValue()).floatValue());
    }
}

