/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="FusedPadConv2D", inputsClass=Inputs.class)
public final class FusedPadConv2d<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "FusedPadConv2D";
    private Output<T> output;

    public FusedPadConv2d(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> FusedPadConv2d<T> create(Scope scope, Operand<T> input, Operand<TInt32> paddings, Operand<T> filter, String mode, List<Long> strides, String padding) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "FusedPadConv2d");
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(paddings.asOutput());
        opBuilder.addInput(filter.asOutput());
        opBuilder.setAttr("mode", mode);
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        opBuilder.setAttr("padding", padding);
        return new FusedPadConv2d<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=FusedPadConv2d.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<FusedPadConv2d<T>> {
        public final Operand<T> input;
        public final Operand<TInt32> paddings;
        public final Operand<T> filter;
        public final DataType T;
        public final String mode;
        public final long[] strides;
        public final String padding;

        public Inputs(GraphOperation op) {
            super(new FusedPadConv2d(op), op, Arrays.asList("T", "mode", "strides", "padding"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.paddings = op.input(inputIndex++);
            this.filter = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.mode = op.attributes().getAttrString("mode");
            this.strides = op.attributes().getAttrIntList("strides");
            this.padding = op.attributes().getAttrString("padding");
        }
    }
}

