/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="LeakyReluGrad", inputsClass=Inputs.class)
public final class LeakyReluGrad<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "LeakyReluGrad";
    private Output<T> backprops;

    public LeakyReluGrad(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.backprops = operation.output(outputIdx++);
    }

    public static <T extends TNumber> LeakyReluGrad<T> create(Scope scope, Operand<T> gradients, Operand<T> features, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(gradients.asOutput());
        opBuilder.addInput(features.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.alpha == null) continue;
                opBuilder.setAttr("alpha", opts.alpha.floatValue());
            }
        }
        return new LeakyReluGrad<T>(opBuilder.build());
    }

    public static Options alpha(Float alpha) {
        return new Options().alpha(alpha);
    }

    public Output<T> backprops() {
        return this.backprops;
    }

    @Override
    public Output<T> asOutput() {
        return this.backprops;
    }

    @OpInputsMetadata(outputsClass=LeakyReluGrad.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<LeakyReluGrad<T>> {
        public final Operand<T> gradients;
        public final Operand<T> features;
        public final float alpha;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new LeakyReluGrad(op), op, Arrays.asList("alpha", "T"));
            int inputIndex = 0;
            this.gradients = op.input(inputIndex++);
            this.features = op.input(inputIndex++);
            this.alpha = op.attributes().getAttrFloat("alpha");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Float alpha;

        private Options() {
        }

        public Options alpha(Float alpha) {
            this.alpha = alpha;
            return this;
        }
    }
}

