/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.loadbalance.config;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClientConfiguration;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClientSpecification;
import org.springframework.cloud.loadbalancer.core.ReactorLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.violet.common.loadbalance.config.VioletBalancerProperties;
import org.violet.common.loadbalance.processor.GrayscaleLoadBalancer;

@AutoConfiguration
@AutoConfigureBefore(value={LoadBalancerClientConfiguration.class})
@EnableConfigurationProperties(value={VioletBalancerProperties.class})
@ConditionalOnProperty(value={"violet.loadbalancer.enabled"}, matchIfMissing=true)
@Order(value=193827465)
public class VioletLoadBalancerConfiguration {
    public static final int REACTIVE_SERVICE_INSTANCE_SUPPLIER_ORDER = 193827465;

    @Bean
    public ReactorLoadBalancer<ServiceInstance> reactorServiceInstanceLoadBalancer(Environment environment, LoadBalancerClientFactory loadBalancerClientFactory, VioletBalancerProperties violetLoadBalancerProperties) {
        String name = environment.getProperty("loadbalancer.client.name");
        return new GrayscaleLoadBalancer((ObjectProvider<ServiceInstanceListSupplier>)loadBalancerClientFactory.getLazyProvider(name, ServiceInstanceListSupplier.class), violetLoadBalancerProperties);
    }

    @Bean
    public LoadBalancerClientSpecification loadBalancerClientSpecification() {
        return new LoadBalancerClientSpecification("default.violetLoadBalancerConfiguration", new Class[]{VioletLoadBalancerConfiguration.class});
    }
}

