package org.violet.common.launch.config.launch;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

import java.io.IOException;
import java.util.List;

/***
 * 环境处理后置处理器，用于自定义配置文件位置
 * @author wjx
 * @date 2024/11/26 14:56
 */
public class VioletEnvironmentPostProcessor implements EnvironmentPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(VioletEnvironmentPostProcessor.class);
    private final YamlPropertySourceLoader loader = new YamlPropertySourceLoader();
    private static final String DEF_YML_PATH = "classpath*:config/violet-**.yml";


    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        try {
            Resource[] resources = (new PathMatchingResourcePatternResolver()).getResources(DEF_YML_PATH);
            int length = resources.length;

            for (int i = 0; i < length; ++i) {
                Resource resource = resources[i];
                List<PropertySource<?>> configs = this.loader.load(resource.getFilename(), resource);
                if (configs != null && !configs.isEmpty()) {
                    environment.getPropertySources().addLast(configs.get(0));
                }
            }

        } catch (IOException e) {
            log.error("Load module config fail", e);
            throw new RuntimeException(e);
        }
    }
}
