/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.core.util;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.URLUtil;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.violet.common.core.exception.BizException;

public class CommonDownloadUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonDownloadUtil.class);

    public static void download(File file, HttpServletResponse response) {
        CommonDownloadUtil.download(file.getName(), FileUtil.readBytes((File)file), response);
    }

    public static void download(String fileName, byte[] fileBytes, HttpServletResponse response) {
        try {
            response.setHeader("Content-Disposition", "attachment;filename=" + URLUtil.encode((String)fileName));
            response.addHeader("Content-Length", "" + fileBytes.length);
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.setContentType("application/octet-stream;charset=UTF-8");
            IoUtil.write((OutputStream)response.getOutputStream(), (boolean)true, (byte[])fileBytes);
        }
        catch (IOException e) {
            throw new BizException(e.getMessage());
        }
    }
}

