/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.core.util;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson2.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.violet.common.core.exception.BizException;

public class CascadeUtil {
    public static void main(String[] args) {
        ArrayList<CascadeItem> data = new ArrayList<CascadeItem>();
        CascadeItem a = new CascadeItem(1, 0, "a");
        data.add(a);
        CascadeItem a1 = new CascadeItem(2, 1, "a1");
        data.add(a1);
        CascadeItem a2 = new CascadeItem(3, 1, "a2");
        data.add(a2);
        CascadeItem a11 = new CascadeItem(4, 2, "a11");
        data.add(a11);
        CascadeItem b = new CascadeItem(5, 0, "b");
        data.add(b);
        CascadeUtil.cascade(data, "-");
        System.out.println(JSON.toJSONString(data));
    }

    public static void cascade(List<CascadeItem> data, String connector) {
        if (CollUtil.isEmpty(data)) {
            return;
        }
        HashMap<Object, CascadeItem> map = new HashMap<Object, CascadeItem>();
        for (CascadeItem item : data) {
            map.put(item.getKey(), item);
        }
        try {
            for (CascadeItem item : data) {
                CascadeItem parent;
                Object keyVal = item.getKey();
                Object parentVal = item.getParentKey();
                map.put(keyVal, item);
                if (CascadeUtil.isRootNode(parentVal) || null == (parent = (CascadeItem)map.get(parentVal))) continue;
                if (null == parent.getChildren()) {
                    parent.setChildren(new ArrayList<CascadeItem>());
                }
                parent.getChildren().add(item);
            }
            List pool = map.values().stream().filter(row -> CascadeUtil.isRootNode(row.getParentKey())).collect(Collectors.toList());
            while (pool.size() > 0) {
                CascadeItem current = (CascadeItem)pool.remove(0);
                Object parentVal = current.getParentKey();
                Object cascadeVal = CascadeUtil.isRootNode(parentVal) ? current.getText() : current.getCascadeText() + connector + current.getText();
                current.setCascadeText((String)cascadeVal);
                List<CascadeItem> children = current.getChildren();
                current.setChildren(null);
                if (!CollUtil.isNotEmpty(children)) continue;
                for (CascadeItem item : children) {
                    item.setCascadeText((String)cascadeVal);
                }
                pool.addAll(children);
            }
        }
        catch (Exception e) {
            throw new BizException(e.getMessage(), e);
        }
    }

    private static boolean isRootNode(Object parentValue) {
        if (null == parentValue) {
            return true;
        }
        if (parentValue instanceof String) {
            return ((String)parentValue).trim().equals("0");
        }
        if (parentValue instanceof Integer) {
            return (Integer)parentValue == 0;
        }
        if (parentValue instanceof Long) {
            return (Long)parentValue == 0L;
        }
        return false;
    }

    public static class CascadeItem {
        private final Object key;
        private final Object parentKey;
        private final String text;
        private String cascadeText = "";
        private List<CascadeItem> children;

        public CascadeItem(Object key, Object parentKey, String text) {
            this.key = key;
            this.parentKey = parentKey;
            this.text = text;
        }

        @Generated
        public Object getKey() {
            return this.key;
        }

        @Generated
        public Object getParentKey() {
            return this.parentKey;
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public String getCascadeText() {
            return this.cascadeText;
        }

        @Generated
        public List<CascadeItem> getChildren() {
            return this.children;
        }

        @Generated
        public void setCascadeText(String cascadeText) {
            this.cascadeText = cascadeText;
        }

        @Generated
        public void setChildren(List<CascadeItem> children) {
            this.children = children;
        }
    }
}

