/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.core.convert;

import cn.hutool.core.util.ReflectUtil;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.core.Converter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;
import org.violet.common.core.support.Try;
import org.violet.common.core.util.ClassUtil;
import org.violet.common.core.util.ConvertUtil;

public class VioletConverter
implements Converter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VioletConverter.class);
    private static final ConcurrentMap<String, TypeDescriptor> TYPE_CACHE = new ConcurrentHashMap<String, TypeDescriptor>();
    private final Class<?> targetClazz;

    @Nullable
    public Object convert(Object value, Class target, Object fieldName) {
        if (value == null) {
            return null;
        }
        if (ClassUtil.isAssignableValue((Class)target, (Object)value)) {
            return value;
        }
        try {
            TypeDescriptor targetDescriptor = VioletConverter.getTypeDescriptor(this.targetClazz, (String)fieldName);
            return ConvertUtil.convert(value, targetDescriptor);
        }
        catch (Throwable e) {
            log.warn("VioletConverter error", e);
            return null;
        }
    }

    private static TypeDescriptor getTypeDescriptor(Class<?> clazz, String fieldName) {
        String srcCacheKey = clazz.getName() + fieldName;
        return TYPE_CACHE.computeIfAbsent(srcCacheKey, Try.of(k -> {
            Field field = ReflectUtil.getField((Class)clazz, (String)fieldName);
            if (field == null) {
                throw new NoSuchFieldException(fieldName);
            }
            return new TypeDescriptor(field);
        }));
    }

    @Generated
    public VioletConverter(Class<?> targetClazz) {
        this.targetClazz = targetClazz;
    }
}

