/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.core.config.mvc;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import lombok.Generated;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.violet.common.core.config.mvc.RequestProperties;
import org.violet.common.core.filter.VioletRequestFilter;
import org.violet.common.core.xss.XssProperties;

@AutoConfiguration
@EnableConfigurationProperties(value={RequestProperties.class, XssProperties.class})
public class RequestConfiguration {
    private final RequestProperties requestProperties;
    private final XssProperties xssProperties;

    @Bean
    public FilterRegistrationBean<VioletRequestFilter> violetFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
        registration.setFilter((Filter)new VioletRequestFilter(this.requestProperties, this.xssProperties));
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("violetRequestFilter");
        registration.setOrder(Integer.MAX_VALUE);
        return registration;
    }

    @Generated
    public RequestConfiguration(RequestProperties requestProperties, XssProperties xssProperties) {
        this.requestProperties = requestProperties;
        this.xssProperties = xssProperties;
    }
}

