package org.violet.common.core.node;

import lombok.Data;
import lombok.experimental.Accessors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author l7
 * @version 1.0
 * @description TODO
 * @date 2023/3/16 14:41
 */
@Data
@Accessors(chain = true)
public class TreeNode {
    /**
     * Accessors(chain = true) 当该值为 true 时，对应字段的 setter 方法调用后，会返回当前对象
     */
    private Object id;
    private String text;
    private String state;
    private List<TreeNode> children;
    private Map<String,Object> attr = new HashMap<>();

    public static TreeNode of(Object id,String text) {
        return new TreeNode().setId(id).setText(text);
    }

    public void addChild(TreeNode node){
        if(children == null){
            children = new ArrayList<>();
        }
        children.add(node);
    }

    public TreeNode set(String key,String value){
        this.attr.put(key,value);
        return this;
    }
}
