package org.violet.common.core.intefaces.workflow;


import org.violet.common.core.entity.workflow.*;

import java.util.List;

/**
 * 工作流相关统一接口
 *
 * @author fyin
 * @date 2024年05月09日 10:25
 */
public interface WorkFlowApi {
    /**
     * 返回流程的用户列表
     *
     * @return
     */
    List<WfUser> userList();

    /**
     * 返回流程的组织机构列表
     *
     * @return
     */
    List<WfOrg> orgList();

    /**
     * 返回流程的部门列表
     *
     * @return
     */
    List<WfDept> deptList();

    /**
     * 角色列表
     *
     * @return
     */
    List<WfRole> roleList();

    List<WfPosition> positionList();

    /**
     * 获取指定部门的部门主管ID
     * @param deptId
     * @return
     */
    String getSupervisorIdByDeptId(String deptId);

    /**
     * 获取指定角色列表对应的人员ID列表
     * @param roleIdList
     * @return
     */
    List<String> getUserIdsByRoleIds(List<String> roleIdList);
    /**
     * 根据职位id集合获取职位下用户id集合
     *
     *
     * @date 2022/6/6 11:44
     **/
    List<String> getUserIdsByPositionIds(List<String> positionIdList);
}
