package org.violet.common.core.enums;

import cn.hutool.core.util.StrUtil;
import org.violet.common.core.embed.dict.DataModelColumnType;
import org.violet.common.core.intefaces.IEmbedDic;

public enum EmbedTableColumn implements IEmbedDic {
    DELETED("逻辑删除", DataModelColumnType.LOGIC_DELETE),
    CREATE_BY("创建人", DataModelColumnType.BIGINT),
    MODIFY_BY("修改人", DataModelColumnType.BIGINT),
    CREATE_TIME("创建时间", DataModelColumnType.DATETIME),
    MODIFY_TIME("修改时间", DataModelColumnType.DATETIME);

    private final String text;
    private final DataModelColumnType columnType;

    private EmbedTableColumn(String text, DataModelColumnType columnType) {
        this.text = text;
        this.columnType = columnType;
    }

    public String text() {
        return this.text;
    }

    public DataModelColumnType getColumnType() {
        return this.columnType;
    }

    public String column() {
        return this.name().toLowerCase();
    }

    public String filedName() {
        return StrUtil.toCamelCase(this.name().toLowerCase());
    }
}