package org.violet.common.core.entity;


import lombok.Data;
import org.violet.common.core.embed.dict.LoginType;

import java.io.Serializable;
import java.util.Date;

/**
 * 登录日志
 *
 * @TableName base_log_login
 */
@Data
public class LogoutLog implements Serializable {

    private Long userId;

    /**
     * 登录用户名
     */
    private String loginName;

    /**
     * 登录日志类型
     */
    private LoginType loginType;

    /**
     * 日志时间
     */
    private Date logTime;

    /**
     * 登录/退出的IP
     */
    private String logIp;

    /**
     * 操作系统
     */
    private String logOs;

    /**
     * 浏览器
     */
    private String logBrowser;

    /**
     * 操作是否成功
     */
    private Integer successed;

    /**
     * 操作的结果信息
     */
    private String logResult;


}