package org.violet.common.core.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.violet.common.core.constants.ComConst;
import org.violet.common.launch.constant.AppConstant;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;
import org.violet.common.core.enums.Gender;
import org.violet.common.core.enums.LoginUserType;
import org.violet.common.core.enums.UserStatus;
import org.violet.common.core.enums.UserType;

import java.io.Serializable;
import java.util.*;

/***
 * 登录用户实体
 * @author wjx
 * @date 2024/11/28 14:03
 */
@Getter
@Setter
@NoArgsConstructor
public class LoginUser implements Serializable {
    /**
     * 用户ID
     */
    private Long userId;
    /**
     * 组织机构ID
     */
    private Long orgId;
    /**
     * 组织机构名称
     */
    private String orgName;
    /**
     * 部门名称
     */
    private String deptName;
    /**
     * 所属团队id
     */
    private Long groupId;
    /**
     * 部门ID
     */
    private Long deptId;
    /**
     * 登录用户名
     */
    private String userName;
    /**
     * 登录密码
     */
    private String loginPassword;
    /**
     * 姓名
     */
    private String empName;
    /**
     * 性别
     */
    private Gender gender;
    /**
     * 用户类型,普通用户,开发者,root
     */
    private LoginUserType loginUserType = LoginUserType.NORMAL;

    /**
     * 用户本身类型员工,外协等
     */
    private UserType userType;
    /**
     * 生日
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date birthday;
    /**
     * 头像
     */
    private String userAvatar;
    /**
     * 昵称
     */
    private String nickName;
    /**
     * 电话号
     */
    private String phone;

    /**
     * 手机号
     */
    private String mobile;
    /**
     * 邮件地址
     */
    private String email;
    /**
     * 扩展信息
     */
    private String extInfo;

    private UserStatus userStatus;
    /**
     *
     */
    private String ipAddress;
    private String browser;
    private String os;
    private boolean enabled = true;
    /**
     * 是否是切换来的用户
     */
    private boolean switchUser = false;
    /**
     * 是从哪个用户切换过来的
     */
    private Long switchForm;
    /**
     * todo: 职位ID     *
     */
    private String positionId;

    private Double longtitude;
    private Double latitude;

    /**
     * 用户的树形菜单列表
     */
    private List<MenuRouterVo> menus = new ArrayList<>();
    /**
     * 用户权限编码集合
     * key:MENU,BUTTON,DATA
     */
    private Map<String, List<String>> authMap = new HashMap<>();
    /**
     * 系统首页ID,如果没有分配,则是0
     */
    private Long homePageId;

    /**
     * 用户角色集合
     */
    private List<Long> roleIdList = new ArrayList<>();

    public boolean isRoot() {
        return this.loginUserType == LoginUserType.ROOT;
    }

    /**
     * 是否需要提醒用户修改密码
     */
    private Boolean hasChangePwd = false;

    /**
     * 是否访客角色
     */
    private Boolean isVisitor = false;

    public static LoginUser buildRoot(String empName) {
        LoginUser root = new LoginUser();
        root.setLoginUserType(LoginUserType.ROOT);
        root.setUserName(empName);
        root.setEmpName(ComConst.DEF_ROOT_FULL_NAME);
        root.setNickName(ComConst.DEF_ROOT_FULL_NAME);
        root.setUserAvatar(ComConst.DEF_ROOT_AVATAR);
        root.setUserStatus(UserStatus.NORMAL);
        root.setEnabled(true);
        root.setUserId(ComConst.DEF_ROOT_USER_ID);
        root.setOrgId(ComConst.DEF_ROOT_ORG_ID);
        root.setOrgName(ComConst.DEF_ROOT_FULL_NAME);
        root.setDeptName(ComConst.DEF_ROOT_FULL_NAME);
        root.setDeptId(0L);
        return root;
    }

    public boolean isSwitchUser() {
        return this.switchUser;
    }

    public Long getSwitchForm() {
        return switchForm;
    }

}