package org.violet.common.core.embed.dict;


import org.violet.common.core.annotation.EmbedDict;
import org.violet.common.core.intefaces.IEmbedDic;

@EmbedDict("数据模型关联类型")
public enum DataModelRelType implements IEmbedDic {
    /**
     * 关联类型，一对一，一对多
     */
    ONE("一对一"),
    MANY("一对多");

    private String text;

    DataModelRelType(String text) {
        this.text = text;
    }

    @Override
    public String text() {
        return this.text;
    }
}

