package org.violet.common.core.annotation;





import org.violet.common.core.enums.OptType;

import java.lang.annotation.*;

@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface OptLog {
    /**
     * 操作日志的标题
     *
     * @return
     */
    String title();

    /**
     * 操作类型
     *
     * @return
     */
    OptType type();

    /**
     * 可以使用模版的方式定义操作日志的记录文字内容
     *
     * @return
     */
    LogDetail detail() default @LogDetail(success = "", error = "");

    /**
     * 自定义指定操作人,默认为loginUser.getUserName
     *
     * @return
     */
    String operator() default "";

    /**
     * 是否记录请求参数
     *
     * @return
     */
    boolean logRequest() default true;

    /**
     * 是否记录响应结果
     *
     * @return
     */
    boolean logResponse() default true;

    /**
     * 操作成功记录的文字模版 支持SpEL表达式
     *
     * @return
     */
    String success() default "";

    /**
     * 操作失败的文字模版,支持SpEL表达式
     *
     * @return
     */
    String error() default "";

}
