/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.core.util;

import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.HtmlUtils;
import org.violet.common.core.support.StrSpliter;
import org.violet.common.core.util.Func;
import org.violet.common.core.util.Holder;
import org.violet.common.core.util.NumberUtil;
import org.violet.common.core.util.ObjectUtil;
import org.violet.common.core.util.RandomType;

public class StringUtil
extends StringUtils {
    public static final int INDEX_NOT_FOUND = -1;
    private static final int PAD_LIMIT = 8192;
    private static final String S_INT = "0123456789";
    private static final String S_STR = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String S_ALL = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    public static boolean isBlank(CharSequence cs) {
        return !StringUtil.hasText((CharSequence)cs);
    }

    public static boolean isNotBlank(CharSequence cs) {
        return StringUtil.hasText((CharSequence)cs);
    }

    public static boolean isAnyBlank(CharSequence ... css) {
        if (ObjectUtil.isEmpty((Object[])css)) {
            return true;
        }
        return Stream.of(css).anyMatch(StringUtil::isBlank);
    }

    public static boolean isNoneBlank(CharSequence ... css) {
        if (ObjectUtil.isEmpty((Object[])css)) {
            return false;
        }
        return Stream.of(css).allMatch(StringUtil::isNotBlank);
    }

    public static boolean isNumeric(CharSequence cs) {
        if (StringUtil.isBlank(cs)) {
            return false;
        }
        int i = cs.length();
        while (--i >= 0) {
            char chr = cs.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            return false;
        }
        return true;
    }

    public static String join(Collection<?> coll) {
        return StringUtil.collectionToCommaDelimitedString(coll);
    }

    public static String join(Collection<?> coll, String delim) {
        return StringUtil.collectionToDelimitedString(coll, (String)delim);
    }

    public static String join(Object[] arr) {
        return StringUtil.arrayToCommaDelimitedString((Object[])arr);
    }

    public static String join(Object[] arr, String delim) {
        return StringUtil.arrayToDelimitedString((Object[])arr, (String)delim);
    }

    public static String randomUUID() {
        return StringUtil.getId(ThreadLocalRandom.current(), 32, 16);
    }

    public static String getFastId(int len) {
        return StringUtil.getId(ThreadLocalRandom.current(), len, 62);
    }

    public static String getSafeId(int len) {
        return StringUtil.getId(Holder.SECURE_RANDOM, len, 62);
    }

    public static String getId(Random random, int len) {
        return StringUtil.getId(random, len, 62);
    }

    public static String getId(Random random, int len, int radix) {
        if (len < 8) {
            throw new IllegalArgumentException("\u4e3a\u4e86\u51cf\u5c11\u51b2\u7a81\uff0clen \u9700\u8981\u5927\u4e8e7\uff0c\u5b9e\u9645\u5c3d\u91cf\u8bbe\u7f6e\u572810~16\u6216\u4ee5\u4e0a\u3002");
        }
        byte[] randomBytes = new byte[len];
        random.nextBytes(randomBytes);
        int mask = radix - 1;
        for (int i = 0; i < len; ++i) {
            randomBytes[i] = NumberUtil.DIGITS[randomBytes[i] & 0xFF & mask];
        }
        return new String(randomBytes, StandardCharsets.ISO_8859_1);
    }

    public static String escapeHtml(String html) {
        return StringUtil.isBlank(html) ? "" : HtmlUtils.htmlEscape((String)html);
    }

    public static String cleanChars(String txt) {
        return txt.replaceAll("[ \u3000`\u00b7\u2022\ufffd\u0001\\f\\t\\v\\s]", "");
    }

    public static String random(int count) {
        return StringUtil.random(count, RandomType.ALL);
    }

    public static String random(int count, RandomType randomType) {
        if (count == 0) {
            return "";
        }
        Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)("Requested random string length " + count + " is less than 0."));
        ThreadLocalRandom random = ThreadLocalRandom.current();
        char[] buffer = new char[count];
        for (int i = 0; i < count; ++i) {
            buffer[i] = RandomType.INT == randomType ? S_INT.charAt(random.nextInt(S_INT.length())) : (RandomType.STRING == randomType ? S_STR.charAt(random.nextInt(S_STR.length())) : S_ALL.charAt(random.nextInt(S_ALL.length())));
        }
        return new String(buffer);
    }

    public static String format(@Nullable String message, @Nullable Map<String, ?> params) {
        int end;
        int start;
        if (message == null) {
            return "";
        }
        if (params == null || params.isEmpty()) {
            return message;
        }
        StringBuilder sb = new StringBuilder((int)((double)message.length() * 1.5));
        int cursor = 0;
        while ((start = message.indexOf("${", cursor)) != -1 && (end = message.indexOf("}", start)) != -1) {
            sb.append(message, cursor, start);
            String key = message.substring(start + 2, end);
            Object value = params.get(key.strip());
            sb.append((Object)(value == null ? "" : value));
            cursor = end + 1;
        }
        sb.append(message.substring(cursor));
        return sb.toString();
    }

    public static String format(@Nullable String message, Object ... arguments) {
        int end;
        int start;
        if (message == null) {
            return "";
        }
        if (arguments == null || arguments.length == 0) {
            return message;
        }
        StringBuilder sb = new StringBuilder((int)((double)message.length() * 1.5));
        int cursor = 0;
        int argsLength = arguments.length;
        for (int index = 0; (start = message.indexOf("{", cursor)) != -1 && (end = message.indexOf("}", start)) != -1 && index < argsLength; ++index) {
            sb.append(message, cursor, start);
            sb.append(arguments[index]);
            cursor = end + 1;
        }
        sb.append(message.substring(cursor));
        return sb.toString();
    }

    public static String format(long nanos) {
        if (nanos < 1L) {
            return "0ms";
        }
        double millis = (double)nanos / 1000000.0;
        if (millis > 1000.0) {
            return String.format("%.3fs", millis / 1000.0);
        }
        return String.format("%.3fms", millis);
    }

    @Nullable
    public static String cleanIdentifier(@Nullable String param) {
        if (param == null) {
            return null;
        }
        StringBuilder paramBuilder = new StringBuilder();
        for (int i = 0; i < param.length(); ++i) {
            char c = param.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) continue;
            paramBuilder.append(c);
        }
        return paramBuilder.toString();
    }

    public static List<String> split(CharSequence str, char separator, int limit) {
        return StringUtil.split(str, separator, limit, false, false);
    }

    public static List<String> splitTrim(CharSequence str, char separator) {
        return StringUtil.splitTrim(str, separator, -1);
    }

    public static List<String> splitTrim(CharSequence str, CharSequence separator) {
        return StringUtil.splitTrim(str, separator, -1);
    }

    public static List<String> splitTrim(CharSequence str, char separator, int limit) {
        return StringUtil.split(str, separator, limit, true, true);
    }

    public static List<String> splitTrim(CharSequence str, CharSequence separator, int limit) {
        return StringUtil.split(str, separator, limit, true, true);
    }

    public static List<String> split(CharSequence str, char separator, boolean isTrim, boolean ignoreEmpty) {
        return StringUtil.split(str, separator, 0, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (null == str) {
            return new ArrayList<String>(0);
        }
        return StrSpliter.split(str.toString(), separator, limit, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence str, CharSequence separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (null == str) {
            return new ArrayList<String>(0);
        }
        String separatorStr = null == separator ? null : separator.toString();
        return StrSpliter.split(str.toString(), separatorStr, limit, isTrim, ignoreEmpty);
    }

    public static String[] split(CharSequence str, CharSequence separator) {
        if (str == null) {
            return new String[0];
        }
        String separatorStr = null == separator ? null : separator.toString();
        return StrSpliter.splitToArray(str.toString(), separatorStr, 0, false, false);
    }

    public static String[] split(CharSequence str, int len) {
        if (null == str) {
            return new String[0];
        }
        return StrSpliter.splitByLength(str.toString(), len);
    }

    public static boolean contains(CharSequence str, char searchChar) {
        return StringUtil.indexOf(str, searchChar) > -1;
    }

    public static boolean containsAny(CharSequence str, CharSequence ... testStrs) {
        return null != StringUtil.getContainsStr(str, testStrs);
    }

    public static String getContainsStr(CharSequence str, CharSequence ... testStrs) {
        if (StringUtil.isEmpty((Object)str) || Func.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence checkStr : testStrs) {
            if (!str.toString().contains(checkStr)) continue;
            return checkStr.toString();
        }
        return null;
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence testStr) {
        if (null == str) {
            return null == testStr;
        }
        return str.toString().toLowerCase().contains(testStr.toString().toLowerCase());
    }

    public static boolean containsAnyIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        return null != StringUtil.getContainsStrIgnoreCase(str, testStrs);
    }

    public static String getContainsStrIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        if (StringUtil.isEmpty((Object)str) || Func.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence testStr : testStrs) {
            if (!StringUtil.containsIgnoreCase(str, testStr)) continue;
            return testStr.toString();
        }
        return null;
    }

    public static String sub(CharSequence str, int fromIndex, int toIndex) {
        if (StringUtil.isEmpty((Object)str)) {
            return "";
        }
        int len = str.length();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return "";
        }
        return str.toString().substring(fromIndex, toIndex);
    }

    public static String subBefore(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (StringUtil.isEmpty((Object)string) || separator == null) {
            return null == string ? null : string.toString();
        }
        String str = string.toString();
        String sep = separator.toString();
        if (sep.isEmpty()) {
            return "";
        }
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String subAfter(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (StringUtil.isEmpty((Object)string)) {
            return null == string ? null : string.toString();
        }
        if (separator == null) {
            return "";
        }
        String str = string.toString();
        String sep = separator.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (pos == -1) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static String subBetween(CharSequence str, CharSequence before, CharSequence after) {
        int end;
        if (str == null || before == null || after == null) {
            return null;
        }
        String str2 = str.toString();
        String before2 = before.toString();
        String after2 = after.toString();
        int start = str2.indexOf(before2);
        if (start != -1 && (end = str2.indexOf(after2, start + before2.length())) != -1) {
            return str2.substring(start + before2.length(), end);
        }
        return null;
    }

    public static String subBetween(CharSequence str, CharSequence beforeAndAfter) {
        return StringUtil.subBetween(str, beforeAndAfter, beforeAndAfter);
    }

    public static String removePrefix(CharSequence str, CharSequence prefix) {
        if (StringUtil.isEmpty((Object)str) || StringUtil.isEmpty((Object)prefix)) {
            return "";
        }
        String str2 = str.toString();
        if (str2.startsWith(prefix.toString())) {
            return StringUtil.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removePrefixIgnoreCase(CharSequence str, CharSequence prefix) {
        if (StringUtil.isEmpty((Object)str) || StringUtil.isEmpty((Object)prefix)) {
            return "";
        }
        String str2 = str.toString();
        if (str2.toLowerCase().startsWith(prefix.toString().toLowerCase())) {
            return StringUtil.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removeSuffix(CharSequence str, CharSequence suffix) {
        if (StringUtil.isEmpty((Object)str) || StringUtil.isEmpty((Object)suffix)) {
            return "";
        }
        String str2 = str.toString();
        if (str2.endsWith(suffix.toString())) {
            return StringUtil.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String removeSufAndLowerFirst(CharSequence str, CharSequence suffix) {
        return StringUtil.lowerFirst(StringUtil.removeSuffix(str, suffix));
    }

    public static String removeSuffixIgnoreCase(CharSequence str, CharSequence suffix) {
        if (StringUtil.isEmpty((Object)str) || StringUtil.isEmpty((Object)suffix)) {
            return "";
        }
        String str2 = str.toString();
        if (str2.toLowerCase().endsWith(suffix.toString().toLowerCase())) {
            return StringUtil.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String lowerFirst(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String upperFirst(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static String subPre(CharSequence string, int toIndex) {
        return StringUtil.sub(string, 0, toIndex);
    }

    public static String subSuf(CharSequence string, int fromIndex) {
        if (StringUtil.isEmpty((Object)string)) {
            return null;
        }
        return StringUtil.sub(string, fromIndex, string.length());
    }

    public static int indexOf(CharSequence str, char searchChar) {
        return StringUtil.indexOf(str, searchChar, 0);
    }

    public static int indexOf(CharSequence str, char searchChar, int start) {
        if (str instanceof String) {
            return ((String)str).indexOf(searchChar, start);
        }
        return StringUtil.indexOf(str, searchChar, start, -1);
    }

    public static int indexOf(CharSequence str, char searchChar, int start, int end) {
        int len = str.length();
        if (start < 0 || start > len) {
            start = 0;
        }
        if (end > len || end < 0) {
            end = len;
        }
        for (int i = start; i < end; ++i) {
            if (str.charAt(i) != searchChar) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return StringUtil.indexOfIgnoreCase(str, searchStr, 0);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return StringUtil.indexOf(str, searchStr, fromIndex, true);
    }

    public static int indexOf(CharSequence str, CharSequence searchStr, int fromIndex, boolean ignoreCase) {
        int endLimit;
        if (str == null || searchStr == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex > (endLimit = str.length() - searchStr.length() + 1)) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return fromIndex;
        }
        if (!ignoreCase) {
            return str.toString().indexOf(searchStr.toString(), fromIndex);
        }
        for (int i = fromIndex; i < endLimit; ++i) {
            if (!StringUtil.isSubEquals(str, i, searchStr, 0, searchStr.length(), true)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return StringUtil.lastIndexOfIgnoreCase(str, searchStr, str.length());
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return StringUtil.lastIndexOf(str, searchStr, fromIndex, true);
    }

    public static int lastIndexOf(CharSequence str, CharSequence searchStr, int fromIndex, boolean ignoreCase) {
        if (str == null || searchStr == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        fromIndex = Math.min(fromIndex, str.length());
        if (searchStr.length() == 0) {
            return fromIndex;
        }
        if (!ignoreCase) {
            return str.toString().lastIndexOf(searchStr.toString(), fromIndex);
        }
        for (int i = fromIndex; i > 0; --i) {
            if (!StringUtil.isSubEquals(str, i, searchStr, 0, searchStr.length(), true)) continue;
            return i;
        }
        return -1;
    }

    public static int ordinalIndexOf(String str, String searchStr, int ordinal) {
        if (str == null || searchStr == null || ordinal <= 0) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return 0;
        }
        int found = 0;
        int index = -1;
        do {
            if ((index = str.indexOf(searchStr, index + 1)) >= 0) continue;
            return index;
        } while (++found < ordinal);
        return index;
    }

    public static boolean isSubEquals(CharSequence str1, int start1, CharSequence str2, int start2, int length, boolean ignoreCase) {
        if (null == str1 || null == str2) {
            return false;
        }
        return str1.toString().regionMatches(ignoreCase, start1, str2.toString(), start2, length);
    }

    public static boolean equals(CharSequence str1, CharSequence str2) {
        return StringUtil.equals(str1, str2, false);
    }

    public static boolean equalsIgnoreCase(CharSequence str1, CharSequence str2) {
        return StringUtil.equals(str1, str2, true);
    }

    public static boolean equals(CharSequence str1, CharSequence str2, boolean ignoreCase) {
        if (null == str1) {
            return str2 == null;
        }
        if (null == str2) {
            return false;
        }
        if (ignoreCase) {
            return str1.toString().equalsIgnoreCase(str2.toString());
        }
        return str1.equals(str2);
    }

    public static StringBuilder builder() {
        return new StringBuilder();
    }

    public static StringBuilder builder(int capacity) {
        return new StringBuilder(capacity);
    }

    public static StringBuilder builder(CharSequence ... strs) {
        StringBuilder sb = new StringBuilder();
        for (CharSequence str : strs) {
            sb.append(str);
        }
        return sb;
    }

    public static StringBuilder appendBuilder(StringBuilder sb, CharSequence ... strs) {
        for (CharSequence str : strs) {
            sb.append(str);
        }
        return sb;
    }

    public static StringReader getReader(CharSequence str) {
        if (null == str) {
            return null;
        }
        return new StringReader(str.toString());
    }

    public static StringWriter getWriter() {
        return new StringWriter();
    }

    public static int count(CharSequence content, CharSequence strForSearch) {
        if (Func.hasEmpty(content, strForSearch) || strForSearch.length() > content.length()) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        String content2 = content.toString();
        String strForSearch2 = strForSearch.toString();
        while ((idx = content2.indexOf(strForSearch2, idx)) > -1) {
            ++count;
            idx += strForSearch.length();
        }
        return count;
    }

    public static int count(CharSequence content, char charForSearch) {
        int count = 0;
        if (StringUtil.isEmpty((Object)content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String underlineToHump(String para) {
        String[] a;
        StringBuilder result = new StringBuilder();
        for (String s : a = para.split("_")) {
            if (result.length() == 0) {
                result.append(s.toLowerCase());
                continue;
            }
            result.append(s.substring(0, 1).toUpperCase());
            result.append(s.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String humpToUnderline(String para) {
        para = StringUtil.lowerFirst(para);
        StringBuilder sb = new StringBuilder(para);
        int temp = 0;
        for (int i = 0; i < para.length(); ++i) {
            if (!Character.isUpperCase(para.charAt(i))) continue;
            sb.insert(i + temp, "_");
            ++temp;
        }
        return sb.toString().toLowerCase();
    }

    public static String lineToHump(String para) {
        String[] a;
        StringBuilder result = new StringBuilder();
        for (String s : a = para.split("-")) {
            if (result.length() == 0) {
                result.append(s.toLowerCase());
                continue;
            }
            result.append(s.substring(0, 1).toUpperCase());
            result.append(s.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String humpToLine(String para) {
        para = StringUtil.lowerFirst(para);
        StringBuilder sb = new StringBuilder(para);
        int temp = 0;
        for (int i = 0; i < para.length(); ++i) {
            if (!Character.isUpperCase(para.charAt(i))) continue;
            sb.insert(i + temp, "-");
            ++temp;
        }
        return sb.toString().toLowerCase();
    }

    public static String firstCharToLower(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpper(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static String repeat(char ch, int repeat) {
        if (repeat <= 0) {
            return "";
        }
        char[] buf = new char[repeat];
        Arrays.fill(buf, ch);
        return new String(buf);
    }

    @Nullable
    public static String left(@Nullable String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return "";
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }

    @Nullable
    public static String right(@Nullable String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return "";
        }
        int length = str.length();
        if (length <= len) {
            return str;
        }
        return str.substring(length - len);
    }

    @Nullable
    public static String rightPad(@Nullable String str, int size) {
        return StringUtil.rightPad(str, size, ' ');
    }

    @Nullable
    public static String rightPad(@Nullable String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringUtil.rightPad(str, size, String.valueOf(padChar));
        }
        return str.concat(StringUtil.repeat(padChar, pads));
    }

    @Nullable
    public static String rightPad(@Nullable String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (!StringUtils.hasLength((String)padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtil.rightPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return str.concat(padStr);
        }
        if (pads < padLen) {
            return str.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return str.concat(new String(padding));
    }

    @Nullable
    public static String leftPad(@Nullable String str, int size) {
        return StringUtil.leftPad(str, size, ' ');
    }

    @Nullable
    public static String leftPad(@Nullable String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringUtil.leftPad(str, size, String.valueOf(padChar));
        }
        return StringUtil.repeat(padChar, pads).concat(str);
    }

    @Nullable
    public static String leftPad(@Nullable String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (!StringUtils.hasLength((String)padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtil.leftPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(str);
    }

    @Nullable
    public static String mid(@Nullable String str, int pos, int len) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (len < 0 || pos > length) {
            return "";
        }
        if (pos < 0) {
            pos = 0;
        }
        if (length <= pos + len) {
            return str.substring(pos);
        }
        return str.substring(pos, pos + len);
    }
}

