/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.core.util;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.JakartaServletUtil;
import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import com.alibaba.fastjson2.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.violet.common.launch.entity.JsonResult;

public class ServletUtils
extends JakartaServletUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServletUtils.class);
    public static final String USER_AGENT_HEADER = "User-Agent";
    public static final String SEC_CH_UA_PLATFORM_VERSION = "Sec-Ch-Ua-Platform-Version";

    public static UserAgent getUserAgent() {
        UserAgent userAgent = UserAgentUtil.parse((String)JakartaServletUtil.getHeader((HttpServletRequest)ServletUtils.getRequest(), (String)USER_AGENT_HEADER, (Charset)StandardCharsets.UTF_8));
        return userAgent;
    }

    public static String getClientOS() {
        String winPlatformVersion = JakartaServletUtil.getHeader((HttpServletRequest)ServletUtils.getRequest(), (String)SEC_CH_UA_PLATFORM_VERSION, (Charset)StandardCharsets.UTF_8);
        if (StrUtil.isNotBlank((CharSequence)winPlatformVersion)) {
            Integer version = Convert.toInt((Object)StrUtil.splitToArray((CharSequence)StrUtil.removeAll((CharSequence)winPlatformVersion, (char[])new char[]{'\"'}), (CharSequence)".")[0]);
            if (version >= 13) {
                return "Windows 11.0";
            }
            return "Windows 10.0";
        }
        UserAgent userAgent = ServletUtils.getUserAgent();
        if (userAgent != null) {
            return userAgent.getPlatform().getName() + " " + userAgent.getOsVersion();
        }
        return "Unknown";
    }

    public static String getClientBrowser() {
        UserAgent userAgent = ServletUtils.getUserAgent();
        if (userAgent != null) {
            return userAgent.getBrowser().getName() + "(" + userAgent.getEngine().getName() + ")";
        }
        return "Unknown";
    }

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static HttpServletResponse getResponse() {
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        return response;
    }

    public static String getClientIp() {
        return JakartaServletUtil.getClientIP((HttpServletRequest)ServletUtils.getRequest(), (String[])new String[0]);
    }

    public static void renderJson(HttpServletResponse response, JsonResult json) {
        response.setCharacterEncoding("utf-8");
        JakartaServletUtil.write((HttpServletResponse)response, (String)JSON.toJSONString((Object)json), (String)"application/json");
    }
}

