/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.core.config.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.violet.common.core.config.jackson.AbstractReadWriteJackson2HttpMessageConverter;
import org.violet.common.core.config.jackson.VioletBeanSerializerModifier;
import org.violet.common.core.config.jackson.VioletJacksonProperties;

public class MappingApiJackson2HttpMessageConverter
extends AbstractReadWriteJackson2HttpMessageConverter {
    @Nullable
    private String jsonPrefix;

    public MappingApiJackson2HttpMessageConverter(ObjectMapper objectMapper, VioletJacksonProperties properties) {
        super(objectMapper, MappingApiJackson2HttpMessageConverter.initWriteObjectMapper(objectMapper), MappingApiJackson2HttpMessageConverter.initMediaType(properties));
    }

    private static List<MediaType> initMediaType(VioletJacksonProperties properties) {
        ArrayList<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
        supportedMediaTypes.add(MediaType.APPLICATION_JSON);
        supportedMediaTypes.add(new MediaType("application", "*+json"));
        if (Boolean.TRUE.equals(properties.getSupportTextPlain())) {
            supportedMediaTypes.add(MediaType.TEXT_PLAIN);
        }
        return supportedMediaTypes;
    }

    private static ObjectMapper initWriteObjectMapper(ObjectMapper readObjectMapper) {
        ObjectMapper writeObjectMapper = readObjectMapper.copy();
        writeObjectMapper.setSerializerFactory(writeObjectMapper.getSerializerFactory().withSerializerModifier((BeanSerializerModifier)new VioletBeanSerializerModifier()));
        return writeObjectMapper;
    }

    public void setJsonPrefix(String jsonPrefix) {
        this.jsonPrefix = jsonPrefix;
    }

    public void setPrefixJson(boolean prefixJson) {
        this.jsonPrefix = prefixJson ? ")]}', " : null;
    }

    protected void writePrefix(JsonGenerator generator, Object object) throws IOException {
        if (this.jsonPrefix != null) {
            generator.writeRaw(this.jsonPrefix);
        }
    }
}

