package org.violet.common.core.util;

import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class MimeUtil {
    private static Log logger = LogFactory.get();
    private static Properties propFile = new Properties();

    private MimeUtil() {
    }

    public static String getMimeType(String filename) {
        String extension = FileNameUtil.extName(filename);
        if (extension != null && !"".equals(extension)) {
            String type = propFile.getProperty(extension);
            if (type != null && !"".equals(type)) {
                type = type.split(",")[0].trim();
            } else {
                type = "application/octet-stream";
            }

            return type;
        } else {
            return "application/octet-stream";
        }
    }

    static {
        InputStream in = null;

        try {
            in = MimeUtil.class.getResourceAsStream("/mimetype.properties");
            propFile.load(in);
        } catch (FileNotFoundException var12) {
            logger.error("找不到mime定义文件mimetype.properties，将无法判断文件mime！", new Object[0]);
        } catch (IOException var13) {
            logger.error("读取mimetype.properties失败，将无法判断文件mime！", new Object[0]);
        } finally {
            try {
                if (in != null) {
                    in.close();
                }
            } catch (IOException var11) {
                logger.error("关闭文件失败", new Object[]{var11});
            }

        }

    }
}