package org.violet.common.core.embed.param;


import org.violet.common.core.annotation.EmbedParam;
import org.violet.common.core.enums.ParamType;
import org.violet.common.core.intefaces.IEmbedParam;


@EmbedParam(group = "基本参数")
public enum CommonEmbedParamEnum implements IEmbedParam {
    /**
     * 登录页背景图
     */
    APP_LOGIN_BG("登录页背景图", ParamType.IMAGE, "background.svg", true, "", "登录页的整体背景图"),
    APP_LOGIN_COPYRIGHT("登录页版权信息", ParamType.STRING, "©2020", true, "", "登录页底部的版权信息"),
    APP_DEFAULT_PASSWORD("默认密码", ParamType.STRING, "Abcd1234", false, "", "新建用户时的默认密码"),
    FORCE_CHANGE_PASSWORD("强制修改密码",ParamType.BOOLEAN,"true",false,null,"用户首次登陆是否强制修改密码"),
    PASSWORD_VALIDATOR("密码校验规则",ParamType.SELECT,"passwordB",false,"[{\"text\":\"无特殊要求，不能为空\",\"value\":\"\"},{\"text\":\"8位以上的字母、数字组合\",\"value\":\"passwordA\"},{\"text\":\"8位以上的字母、数字、下划线（_）组合\",\"value\":\"passwordB\"},{\"text\":\"8位以上的大小写字母、数字、下划线（_）组合\",\"value\":\"passwordC\"}]","用户修改密码时指定的密码校验规则");
    private String title;
    private ParamType type;
    private String defValue;
    private boolean annoAccess;
    private String options;
    private String description;

    CommonEmbedParamEnum(String title, ParamType type, String defValue, boolean annoAccess, String options, String description) {
        this.title = title;
        this.type = type;
        this.defValue = defValue;
        this.annoAccess = annoAccess;
        this.description = description;
        this.options = options;
    }


    @Override
    public String title() {
        return this.title;
    }

    @Override
    public ParamType type() {
        return this.type;
    }

    @Override
    public String defValue() {
        return this.defValue;
    }

    @Override
    public boolean anonAccess() {
        return this.annoAccess;
    }

    @Override
    public String options() {
        return this.options;
    }

    @Override
    public String description() {
        return this.description;
    }
}
