package org.violet.common.core.embed.dict;


import org.violet.common.core.annotation.EmbedDict;
import org.violet.common.core.intefaces.IEmbedDic;

/**
 * @author xu.wenchang
 * @version 1.0 2023/08/11
 */
@EmbedDict("用户类型")
public enum UserType implements IEmbedDic {
    EMP("员工"),
    ORG("机构"),
    OTH("外协");
    
    private final String text;
    
    UserType(String text) {
        this.text = text;
    }
    
    @Override
    public String text() {
        return this.text;
    }
}
