package org.violet.common.core.embed.dict;


import org.violet.common.core.annotation.EmbedDict;
import org.violet.common.core.intefaces.IEmbedDic;

/**
 * @author fyin
 * @date 2021-05-11 14:47
 */
@EmbedDict("用户状态")
public enum UserStatus implements IEmbedDic {
    /**
     * 正常
     */
    NORMAL("正常"),
    DISABLE("停用"),
    LOCK("锁定"),
    REVOKE("注销"),
    DORMANT("休眠"),
    EXPIRE("密码到期");
    private String text;

    UserStatus(String text) {
        this.text = text;
    }

    @Override
    public String text() {
        return this.text;
    }
}
