package org.violet.common.core.embed.dict;

import org.violet.common.core.annotation.EmbedDict;
import org.violet.common.core.intefaces.IEmbedDic;

import java.text.SimpleDateFormat;
import java.util.Date;

@EmbedDict("流水号时间格式")
public enum SNTimeFormat implements IEmbedDic {
    YYYYMMDD("yyyyMMdd", "yyyyMMdd"),
    YYYYMM("yyyyMM", "yyyyMM"),
    YYYY("yyyy", "yyyy"),
    NONE("none", "无");

    private final String format;
    private final String text;

    SNTimeFormat(String format, String text) {
        this.format = format;
        this.text = text;
    }

    public String getCurPeriodTimeFormat() {
        if (this == NONE) {
            return "";
        }

        return new SimpleDateFormat(this.format).format(new Date());
    }

    public String format() {
        return this.format;
    }

    @Override
    public String text() {
        return this.text;
    }
}