package org.violet.common.core.embed.dict;


import org.violet.common.core.annotation.EmbedDict;
import org.violet.common.core.intefaces.IEmbedDic;

/**
 * @author fyin
 * @date 2021-05-11 14:39
 */
@EmbedDict("性别")
public enum Gender implements IEmbedDic {
    /**
     * 男性
     */
    MALE("男"),
    /**
     * 女性
     */
    FEMALE("女");
    /**
     * 其他
     */

    private String text;

    Gender(String text) {
        this.text = text;
    }

    @Override
    public String text() {
        return this.text;
    }
}