package org.violet.common.core.embed.dict;

import org.violet.common.core.annotation.EmbedDict;
import org.violet.common.core.intefaces.IEmbedDic;

@EmbedDict("权限类型")
public enum AuthType implements IEmbedDic {
    MENU("菜单权限"),
    BUTTON("公共按钮权限"),
    DATA("数据权限"),
    CUSTOM_BUTTON("自定义权限"),
    VIRTUALLY("虚拟权限") ;
    private String text;

    AuthType(String text) {
        this.text = text;
    }

    @Override
    public String text() {
        return this.text;
    }
}