package org.violet.common.core.config.mvc;

import jakarta.servlet.DispatcherType;
import lombok.AllArgsConstructor;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;
import org.violet.common.core.filter.VioletRequestFilter;
import org.violet.common.core.xss.XssProperties;

/**
 * 过滤器配置类
 */
@AutoConfiguration
@AllArgsConstructor
@EnableConfigurationProperties({RequestProperties.class, XssProperties.class})
public class RequestConfiguration {

    private final RequestProperties requestProperties;
    private final XssProperties xssProperties;

    /**
     * 全局过滤器
     *
     * @return 自定义过滤器
     */
    @Bean
    public FilterRegistrationBean<VioletRequestFilter> violetFilterRegistration() {
        FilterRegistrationBean<VioletRequestFilter> registration = new FilterRegistrationBean<>();
        registration.setDispatcherTypes(DispatcherType.REQUEST);
        registration.setFilter(new VioletRequestFilter(requestProperties, xssProperties));
        registration.addUrlPatterns("/*");
        registration.setName("violetRequestFilter");
        registration.setOrder(Ordered.LOWEST_PRECEDENCE);
        return registration;
    }
}
