/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.core.util;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson2.JSONObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.violet.common.core.exception.BizException;

public class TreeBuilder {
    private static final String KEY_LABEL = "key";
    private static final String PARENT_KEY_LABEL = "parentKey";
    private static final String TITLE_LABEL = "title";
    private static final String CHILDREN_LABEL = "children";
    private String keyLabel = "key";
    private String parentKeyLabel = "parentKey";
    private String titleLabel = "title";
    private String childrenLabel = "children";
    private String keyMap;
    private String parentKeyMap;
    private String titleMap;
    private List<?> data;
    private RootNodeParentKeyType rootNodeParentKeyType = RootNodeParentKeyType.ZERO;
    private boolean isNotRewriteAttrNames;

    public static TreeBuilder builder() {
        return new TreeBuilder();
    }

    public List<?> tree() {
        if (this.isNotRewriteAttrNames) {
            this.keyLabel = this.keyMap;
            this.parentKeyLabel = this.parentKeyMap;
            this.titleLabel = this.titleMap;
        }
        if (CollUtil.isEmpty(this.data)) {
            return Collections.emptyList();
        }
        HashMap<Object, JSONObject> map = new HashMap<Object, JSONObject>();
        try {
            for (Object obj : this.data) {
                JSONObject parent;
                Field[] fields = obj.getClass().getDeclaredFields();
                JSONObject item = new JSONObject();
                for (Field field : fields) {
                    if (field.getName().equals(this.keyMap)) {
                        field.setAccessible(true);
                        item.put((Object)this.keyLabel, field.get(obj));
                    }
                    if (field.getName().equals(this.parentKeyMap)) {
                        field.setAccessible(true);
                        item.put((Object)this.parentKeyLabel, field.get(obj));
                    }
                    if (!field.getName().equals(this.titleMap)) continue;
                    field.setAccessible(true);
                    item.put((Object)this.titleLabel, field.get(obj));
                }
                item.put((Object)"data", obj);
                if (!item.containsKey(this.keyLabel)) continue;
                Object key = item.get(this.keyLabel);
                if (map.containsKey(key)) {
                    JSONObject exists = (JSONObject)map.get(key);
                    item.put((Object)this.childrenLabel, exists.get(this.childrenLabel));
                }
                map.put(key, item);
                Object parentKey = item.get(this.parentKeyLabel);
                if (this.isRootNode(parentKey)) continue;
                if (!map.containsKey(parentKey)) {
                    map.put(parentKey, new JSONObject());
                }
                if (!(parent = (JSONObject)map.get(parentKey)).containsKey(this.childrenLabel)) {
                    parent.put((Object)this.childrenLabel, new ArrayList());
                }
                List children = (List)parent.get(this.childrenLabel);
                children.add(item);
            }
            return map.values().stream().filter(jsonObject -> !map.containsKey(jsonObject.get(this.parentKeyLabel))).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new BizException(e.getMessage(), e);
        }
    }

    public TreeBuilder useData(List<?> data) {
        this.data = data;
        return this;
    }

    public TreeBuilder keyMap(String keyMap) {
        this.keyMap = keyMap;
        return this;
    }

    public TreeBuilder parentKeyMap(String parentKeyMap) {
        this.parentKeyMap = parentKeyMap;
        return this;
    }

    public TreeBuilder titleMap(String titleMap) {
        this.titleMap = titleMap;
        return this;
    }

    public TreeBuilder keyLabel(String keyLabel) {
        this.keyLabel = keyLabel;
        return this;
    }

    public TreeBuilder parentKeyLabel(String parentKeyLabel) {
        this.parentKeyLabel = parentKeyLabel;
        return this;
    }

    public TreeBuilder titleLabel(String titleLabel) {
        this.titleLabel = titleLabel;
        return this;
    }

    public TreeBuilder childrenLabel(String childrenLabel) {
        this.childrenLabel = childrenLabel;
        return this;
    }

    public TreeBuilder rootNodeParentKeyType(RootNodeParentKeyType type) {
        this.rootNodeParentKeyType = type;
        return this;
    }

    public TreeBuilder notRewriteAttrName() {
        this.isNotRewriteAttrNames = true;
        return this;
    }

    private boolean isRootNode(Object parentValue) {
        if (null == parentValue) {
            return true;
        }
        if (this.rootNodeParentKeyType == RootNodeParentKeyType.ZERO) {
            return Long.parseLong(parentValue.toString()) == 0L;
        }
        return false;
    }

    public static enum RootNodeParentKeyType {
        NULL,
        ZERO;

    }
}

