/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.core.util;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.lang.Nullable;
import org.springframework.util.DigestUtils;
import org.violet.common.core.util.Charsets;
import org.violet.common.core.util.Exceptions;
import org.violet.common.core.util.HexUtil;

public class DigestUtil
extends DigestUtils {
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    public static String md5Hex(String data) {
        return DigestUtil.md5DigestAsHex((byte[])data.getBytes(Charsets.UTF_8));
    }

    public static String md5Hex(byte[] bytes) {
        return DigestUtil.md5DigestAsHex((byte[])bytes);
    }

    public static String sha1(String srcStr) {
        return DigestUtil.hash("SHA-1", srcStr);
    }

    public static String sha256(String srcStr) {
        return DigestUtil.hash("SHA-256", srcStr);
    }

    public static String sha384(String srcStr) {
        return DigestUtil.hash("SHA-384", srcStr);
    }

    public static String sha512(String srcStr) {
        return DigestUtil.hash("SHA-512", srcStr);
    }

    public static byte[] hmacMd5(String data, String key) {
        return DigestUtil.hmacMd5(data.getBytes(Charsets.UTF_8), key);
    }

    public static byte[] hmacMd5(byte[] bytes, String key) {
        return DigestUtil.digestHmac("HmacMD5", bytes, key);
    }

    public static String hmacMd5Hex(String data, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacMd5(data.getBytes(Charsets.UTF_8), key));
    }

    public static String hmacMd5Hex(byte[] bytes, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacMd5(bytes, key));
    }

    public static byte[] hmacSha1(String data, String key) {
        return DigestUtil.hmacSha1(data.getBytes(Charsets.UTF_8), key);
    }

    public static byte[] hmacSha1(byte[] bytes, String key) {
        return DigestUtil.digestHmac("HmacSHA1", bytes, key);
    }

    public static String hmacSha1Hex(String data, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacSha1(data.getBytes(Charsets.UTF_8), key));
    }

    public static String hmacSha1Hex(byte[] bytes, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacSha1(bytes, key));
    }

    public static byte[] hmacSha224(String data, String key) {
        return DigestUtil.hmacSha224(data.getBytes(Charsets.UTF_8), key);
    }

    public static byte[] hmacSha224(byte[] bytes, String key) {
        return DigestUtil.digestHmac("HmacSHA224", bytes, key);
    }

    public static String hmacSha224Hex(String data, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacSha224(data.getBytes(Charsets.UTF_8), key));
    }

    public static String hmacSha224Hex(byte[] bytes, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacSha224(bytes, key));
    }

    public static byte[] hmacSha256(String data, String key) {
        return DigestUtil.hmacSha256(data.getBytes(Charsets.UTF_8), key);
    }

    public static byte[] hmacSha256(byte[] bytes, String key) {
        return DigestUtil.digestHmac("HmacSHA256", bytes, key);
    }

    public static String hmacSha256Hex(String data, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacSha256(data.getBytes(Charsets.UTF_8), key));
    }

    public static String hmacSha256Hex(byte[] bytes, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacSha256(bytes, key));
    }

    public static byte[] hmacSha384(String data, String key) {
        return DigestUtil.hmacSha384(data.getBytes(Charsets.UTF_8), key);
    }

    public static byte[] hmacSha384(byte[] bytes, String key) {
        return DigestUtil.digestHmac("HmacSHA384", bytes, key);
    }

    public static String hmacSha384Hex(String data, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacSha384(data.getBytes(Charsets.UTF_8), key));
    }

    public static String hmacSha384Hex(byte[] bytes, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacSha384(bytes, key));
    }

    public static byte[] hmacSha512(String data, String key) {
        return DigestUtil.hmacSha512(data.getBytes(Charsets.UTF_8), key);
    }

    public static byte[] hmacSha512(byte[] bytes, String key) {
        return DigestUtil.digestHmac("HmacSHA512", bytes, key);
    }

    public static String hmacSha512Hex(String data, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacSha512(data.getBytes(Charsets.UTF_8), key));
    }

    public static String hmacSha512Hex(byte[] bytes, String key) {
        return DigestUtil.encodeHex(DigestUtil.hmacSha512(bytes, key));
    }

    public static String digestHmacHex(String algorithm, String text, String key) {
        return DigestUtil.digestHmacHex(algorithm, text.getBytes(StandardCharsets.UTF_8), key);
    }

    public static String digestHmacHex(String algorithm, byte[] bytes, String key) {
        return DigestUtil.encodeHex(DigestUtil.digestHmac(algorithm, bytes, key));
    }

    public static byte[] digestHmac(String algorithm, byte[] bytes, String key) {
        SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(Charsets.UTF_8), algorithm);
        try {
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            return mac.doFinal(bytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String encodeHex(byte[] bytes) {
        return HexUtil.encodeToString(bytes);
    }

    public static byte[] decodeHex(String hexStr) {
        return HexUtil.decode(hexStr);
    }

    public static String hash(String algorithm, String srcStr) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] bytes = md.digest(srcStr.getBytes(Charsets.UTF_8));
            return DigestUtil.toHex(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String toHex(byte[] bytes) {
        StringBuilder ret = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            ret.append(HEX_DIGITS[bytes[i] >> 4 & 0xF]);
            ret.append(HEX_DIGITS[bytes[i] & 0xF]);
        }
        return ret.toString();
    }

    public static boolean slowEquals(@Nullable String a, @Nullable String b) {
        if (a == null || b == null) {
            return false;
        }
        return DigestUtil.slowEquals(a.getBytes(Charsets.UTF_8), b.getBytes(Charsets.UTF_8));
    }

    public static boolean slowEquals(@Nullable byte[] a, @Nullable byte[] b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        int diff = a.length ^ b.length;
        for (int i = 0; i < a.length && i < b.length; ++i) {
            diff |= a[i] ^ b[i];
        }
        return diff == 0;
    }

    public static String encrypt(String data) {
        return DigestUtil.sha1(DigestUtil.md5Hex(data));
    }
}

