/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.core.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import lombok.Generated;
import org.springframework.util.AntPathMatcher;
import org.violet.common.core.config.mvc.RequestProperties;
import org.violet.common.core.config.mvc.VioletHttpServletRequestWrapper;
import org.violet.common.core.xss.XssHttpServletRequestWrapper;
import org.violet.common.core.xss.XssProperties;

public class VioletRequestFilter
implements Filter {
    private final RequestProperties requestProperties;
    private final XssProperties xssProperties;
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();

    public void init(FilterConfig config) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String path = ((HttpServletRequest)request).getServletPath();
        if (!this.requestProperties.getEnabled().booleanValue() || this.isRequestSkip(path)) {
            chain.doFilter(request, response);
        } else if (!this.xssProperties.getEnabled().booleanValue() || this.isXssSkip(path)) {
            VioletHttpServletRequestWrapper violetRequest = new VioletHttpServletRequestWrapper((HttpServletRequest)request);
            chain.doFilter((ServletRequest)violetRequest, response);
        } else {
            XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper((HttpServletRequest)request);
            chain.doFilter((ServletRequest)xssRequest, response);
        }
    }

    private boolean isRequestSkip(String path) {
        return this.requestProperties.getSkipUrl().stream().anyMatch(pattern -> this.antPathMatcher.match(pattern, path));
    }

    private boolean isXssSkip(String path) {
        return this.xssProperties.getSkipUrl().stream().anyMatch(pattern -> this.antPathMatcher.match(pattern, path));
    }

    public void destroy() {
    }

    @Generated
    public VioletRequestFilter(RequestProperties requestProperties, XssProperties xssProperties) {
        this.requestProperties = requestProperties;
        this.xssProperties = xssProperties;
    }
}

