package org.violet.common.core.embed.menu;


import org.violet.common.core.annotation.EmbedMenu;
import org.violet.common.core.intefaces.IEmbedMenu;


@EmbedMenu
public enum BaseEmbedMenuEnum implements IEmbedMenu {
    /**
     * 基础管理
     */
    System("0", "系统管理", "", 999),
    Base(System.name(), "基础管理", "", 0),
    BaseUser(Base.name(), "用户管理", "/base/baseUser/index", 1),
    BaseOrg(Base.name(), "组织机构管理", "/base/baseOrg/index", 2),
    BaseDept(Base.name(), "部门管理", "/base/baseDept/index", 3),
    BaseMenu(Base.name(), "菜单管理", "/base/baseMenu/index", 4),
    BaseRole(Base.name(), "角色权限管理", "/base/baseRole/index", 5),
    BasePosition(Base.name(), "岗位管理", "/base/basePosition/index", 6),

    BaseAppConfig(System.name(), "应用配置", "", 8),
    BaseDict(BaseAppConfig.name(), "字典管理", "/base/baseDict/index", 1),
    BaseEmbedDict(BaseDict.name(), "内置字典", "/base/baseDict/embedDict/index", 0),
    BaseUserDict(BaseDict.name(), "业务字典", "/base/baseDict/userDict/index", 1),
    BaseParam(BaseAppConfig.name(), "系统参数配置", "/base/baseParam/index", 4),

    BaseMonitor(System.name(), "应用监控", "", 9),
    BaseLoginLog(BaseMonitor.name(), "登录日志", "/base/baseLoginLog/index", 2),
    BaseOptLog(BaseMonitor.name(), "操作日志", "/base/baseOptLog/index", 3),
    BaseCacheMonitor(BaseMonitor.name(), "缓存监控", "/base/baseCacheMonitor/index", 5);

    BaseEmbedMenuEnum(String pCode, String menuName, String path, Integer orderNo) {
        this.pCode = pCode;
        this.menuName = menuName;
        this.path = path;
        this.orderNo = orderNo;
    }

    /**
     * 父菜单编码
     */
    private String pCode;
    /**
     * 菜单名称
     */
    private String menuName;

    /**
     * 菜单路径
     */
    private String path;
    /**
     * 菜单顺序号
     */
    private Integer orderNo = 0;

    @Override
    public String menuName() {
        return this.menuName;
    }

    @Override
    public String menuCode() {
        return this.name();
    }

    @Override
    public String menuPCode() {
        return this.pCode;
    }

    @Override
    public String menuPath() {
        return this.path;
    }

    @Override
    public Integer orderNo() {
        return this.orderNo;
    }

}
