package org.violet.common.core.embed.dict;


import org.violet.common.core.annotation.EmbedDict;
import org.violet.common.core.intefaces.IEmbedDic;


@EmbedDict("公共按钮权限")
public enum CommonButtonAuth implements IEmbedDic {
    QUERY("查询"),
    ADD("新增"),
    EDIT("修改"),
    DEL("删除"),
    SAVE("保存"),
    VIEW("查看"),
    APPROVE("审批"),

    PREVIEW("预览"),
    IMPORT("导入"),
    EXPORT("导出"),
    PRINT("打印"),
    COPY("复制"),
    DOWNLOAD("下载"),

    SELECT("选择"),
    OPEN("打开"),
    STATISTIC("统计"),
    COMPUTE("计算"),
    GATHER("汇总"),
    CLEAR("清除");



    private String text;

    CommonButtonAuth(String text) {
        this.text = text;
    }

    @Override
    public String text() {
        return this.text;
    }
    }
