/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.cloud.version;

import feign.MethodMetadata;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.cloud.openfeign.AnnotatedParameterProcessor;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.violet.common.cloud.annotation.ApiVersion;
import org.violet.common.cloud.annotation.UrlVersion;
import org.violet.common.cloud.version.VioletMediaType;
import org.violet.common.core.util.StringUtil;

public class VioletSpringMvcContract
extends SpringMvcContract {
    public VioletSpringMvcContract(List<AnnotatedParameterProcessor> annotatedParameterProcessors, ConversionService conversionService) {
        super(annotatedParameterProcessors, conversionService);
    }

    protected void processAnnotationOnMethod(MethodMetadata data, Annotation methodAnnotation, Method method) {
        if (RequestMapping.class.isInstance(methodAnnotation) || methodAnnotation.annotationType().isAnnotationPresent(RequestMapping.class)) {
            Class<?> targetType = method.getDeclaringClass();
            UrlVersion urlVersion = (UrlVersion)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, UrlVersion.class);
            if (urlVersion == null || StringUtil.isBlank((CharSequence)urlVersion.value())) {
                urlVersion = (UrlVersion)AnnotatedElementUtils.findMergedAnnotation(targetType, UrlVersion.class);
            }
            if (urlVersion != null && StringUtil.isNotBlank((CharSequence)urlVersion.value())) {
                String versionUrl = "/" + urlVersion.value();
                data.template().uri(versionUrl);
            }
            super.processAnnotationOnMethod(data, methodAnnotation, method);
            ApiVersion apiVersion = (ApiVersion)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ApiVersion.class);
            if (apiVersion == null || StringUtil.isBlank((CharSequence)apiVersion.value())) {
                apiVersion = (ApiVersion)AnnotatedElementUtils.findMergedAnnotation(targetType, ApiVersion.class);
            }
            if (apiVersion != null && StringUtil.isNotBlank((CharSequence)apiVersion.value())) {
                VioletMediaType violetMediaType = new VioletMediaType(apiVersion.value());
                data.template().header("Accept", new String[]{violetMediaType.toString()});
            }
        }
    }

    protected boolean processAnnotationsOnParameter(MethodMetadata data, Annotation[] annotations, int paramIndex) {
        boolean httpAnnotation = super.processAnnotationsOnParameter(data, annotations, paramIndex);
        if (!httpAnnotation && "GET".equals(data.template().method().toUpperCase())) {
            for (Annotation parameterAnnotation : annotations) {
                if (parameterAnnotation instanceof RequestBody) continue;
                return false;
            }
            data.queryMapIndex(Integer.valueOf(paramIndex));
            return true;
        }
        return httpAnnotation;
    }
}

