package org.violet.common.bootstrap.handler;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.StrUtil;
import org.violet.common.launch.entity.JsonResult;
import lombok.extern.slf4j.Slf4j;
import org.violet.common.core.spi.PrioritySPIFactory;
import org.violet.common.core.util.CommonServletUtil;

import java.util.*;

@Slf4j
public class GlobalExceptionAdapter {

    public static Map<String, ExceptionAdapter> exceptionAdapterMap = new HashMap();
    public static Map<String, ExceptionAdapter> exceptionAdapterMapWithException = new HashMap();

    public GlobalExceptionAdapter() {
    }

    static {
        PrioritySPIFactory prioritySPIFactory = new PrioritySPIFactory(ExceptionAdapter.class);
        exceptionAdapterMap = prioritySPIFactory.getSPIMap();
        //再次封装成一个权限校验的适配器
        exceptionAdapterMap.entrySet().stream().forEach(entry -> {

            ExceptionAdapter adapter = entry.getValue();
            String[] strings = adapter.supportExceptions();
            if (strings != null && strings.length > 0) {
                for (String clazz : strings) {
                    if (exceptionAdapterMapWithException.containsKey(clazz)) {
                        throw new RuntimeException("存在异常适配器重复配置异常类型：" + clazz);
                    }
                    exceptionAdapterMapWithException.put(clazz, adapter);
                }
            } else {
                throw new RuntimeException("存在异常适配器未配置异常类型");
            }
        });


    }

    public static JsonResult adapterException(Throwable e) {
        if (e instanceof RuntimeException) {
            e = ExceptionUtil.getRootCause(e);
        }
        log.error(StrUtil.format(">>> 请求异常，请求地址：{},异常信息:{}", new Object[]{CommonServletUtil.getRequest().getRequestURL(), e.getMessage()}), e);
        //查找对应的适配器
        if (exceptionAdapterMapWithException.containsKey(e.getClass().getName())) {
            return exceptionAdapterMapWithException.get(e.getClass().getName()).adapter(e);
        }
        JsonResult result = JsonResult.ERROR();
        result.msg(e.getMessage());
        return result;
    }


}