/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls.test;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Vector;
import shaded.org.bouncycastle.asn1.x500.X500Name;
import shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shaded.org.bouncycastle.tls.Certificate;
import shaded.org.bouncycastle.tls.CertificateRequest;
import shaded.org.bouncycastle.tls.DefaultTlsServer;
import shaded.org.bouncycastle.tls.ProtocolVersion;
import shaded.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import shaded.org.bouncycastle.tls.TlsCredentialedDecryptor;
import shaded.org.bouncycastle.tls.TlsCredentialedSigner;
import shaded.org.bouncycastle.tls.TlsFatalAlert;
import shaded.org.bouncycastle.tls.TlsUtils;
import shaded.org.bouncycastle.tls.crypto.TlsCertificate;
import shaded.org.bouncycastle.tls.crypto.TlsCrypto;
import shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCryptoProvider;
import shaded.org.bouncycastle.tls.test.TlsTestConfig;
import shaded.org.bouncycastle.tls.test.TlsTestUtils;

class TlsTestServerImpl
extends DefaultTlsServer {
    protected final TlsTestConfig config;
    protected int firstFatalAlertConnectionEnd = -1;
    protected short firstFatalAlertDescription = (short)-1;
    byte[] tlsUnique = null;

    TlsTestServerImpl(TlsTestConfig config) {
        super(new BcTlsCrypto(new SecureRandom()));
        this.config = config;
    }

    int getFirstFatalAlertConnectionEnd() {
        return this.firstFatalAlertConnectionEnd;
    }

    short getFirstFatalAlertDescription() {
        return this.firstFatalAlertDescription;
    }

    @Override
    public TlsCrypto getCrypto() {
        switch (this.config.serverCrypto) {
            case 1: {
                return new JcaTlsCryptoProvider().setProvider(new BouncyCastleProvider()).create(new SecureRandom(), new SecureRandom());
            }
        }
        return new BcTlsCrypto(new SecureRandom());
    }

    @Override
    protected ProtocolVersion getMaximumVersion() {
        if (this.config.serverMaximumVersion != null) {
            return this.config.serverMaximumVersion;
        }
        return super.getMaximumVersion();
    }

    @Override
    protected ProtocolVersion getMinimumVersion() {
        if (this.config.serverMinimumVersion != null) {
            return this.config.serverMinimumVersion;
        }
        return super.getMinimumVersion();
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        if (alertLevel == 2 && this.firstFatalAlertConnectionEnd == -1) {
            this.firstFatalAlertConnectionEnd = 0;
            this.firstFatalAlertDescription = alertDescription;
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        if (alertLevel == 2 && this.firstFatalAlertConnectionEnd == -1) {
            this.firstFatalAlertConnectionEnd = 1;
            this.firstFatalAlertDescription = alertDescription;
        }
    }

    @Override
    public void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        this.tlsUnique = this.context.exportChannelBinding(1);
    }

    @Override
    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion serverVersion = super.getServerVersion();
        return serverVersion;
    }

    @Override
    public CertificateRequest getCertificateRequest() throws IOException {
        if (this.config.serverCertReq == 0) {
            return null;
        }
        short[] certificateTypes = new short[]{1, 2, 64};
        Vector serverSigAlgs = null;
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.serverVersion) && (serverSigAlgs = this.config.serverCertReqSigAlgs) == null) {
            serverSigAlgs = TlsUtils.getDefaultSupportedSignatureAlgorithms(this.context);
        }
        Vector<X500Name> certificateAuthorities = new Vector<X500Name>();
        certificateAuthorities.addElement(new X500Name("CN=BouncyCastle TLS Test CA"));
        return new CertificateRequest(certificateTypes, serverSigAlgs, certificateAuthorities);
    }

    @Override
    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        boolean isEmpty = clientCertificate == null || clientCertificate.isEmpty();
        if (isEmpty != (this.config.clientAuth == 0)) {
            throw new IllegalStateException();
        }
        if (isEmpty && this.config.serverCertReq == 2) {
            throw new TlsFatalAlert(40);
        }
        TlsCertificate[] chain = clientCertificate.getCertificateList();
        if (!isEmpty && !TlsTestUtils.isCertificateOneOf(this.context.getCrypto(), chain[0], new String[]{"x509-client-dsa.pem", "x509-client-ecdsa.pem", "x509-client-rsa.pem"})) {
            throw new TlsFatalAlert(42);
        }
    }

    protected Vector getSupportedSignatureAlgorithms() {
        if (TlsUtils.isTLSv12(this.context) && this.config.serverAuthSigAlg != null) {
            Vector<SignatureAndHashAlgorithm> signatureAlgorithms = new Vector<SignatureAndHashAlgorithm>(1);
            signatureAlgorithms.addElement(this.config.serverAuthSigAlg);
            return signatureAlgorithms;
        }
        return this.supportedSignatureAlgorithms;
    }

    @Override
    protected TlsCredentialedSigner getDSASignerCredentials() throws IOException {
        return TlsTestUtils.loadSignerCredentials(this.context, this.getSupportedSignatureAlgorithms(), (short)2, "x509-server-dsa.pem", "x509-server-key-dsa.pem");
    }

    @Override
    protected TlsCredentialedSigner getECDSASignerCredentials() throws IOException {
        return TlsTestUtils.loadSignerCredentials(this.context, this.getSupportedSignatureAlgorithms(), (short)3, "x509-server-ecdsa.pem", "x509-server-key-ecdsa.pem");
    }

    @Override
    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
        return TlsTestUtils.loadEncryptionCredentials(this.context, new String[]{"x509-server-rsa-enc.pem", "x509-ca-rsa.pem"}, "x509-server-key-rsa-enc.pem");
    }

    @Override
    protected TlsCredentialedSigner getRSASignerCredentials() throws IOException {
        return TlsTestUtils.loadSignerCredentials(this.context, this.getSupportedSignatureAlgorithms(), (short)1, "x509-server-rsa-sign.pem", "x509-server-key-rsa-sign.pem");
    }
}

