/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls.test;

import java.io.IOException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import junit.framework.TestCase;
import shaded.org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import shaded.org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import shaded.org.bouncycastle.asn1.ocsp.OCSPResponse;
import shaded.org.bouncycastle.cert.X509CertificateHolder;
import shaded.org.bouncycastle.cert.ocsp.BasicOCSPResp;
import shaded.org.bouncycastle.cert.ocsp.CertificateID;
import shaded.org.bouncycastle.cert.ocsp.OCSPException;
import shaded.org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import shaded.org.bouncycastle.cert.ocsp.SingleResp;
import shaded.org.bouncycastle.cert.ocsp.jcajce.JcaCertificateID;
import shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shaded.org.bouncycastle.operator.DigestCalculator;
import shaded.org.bouncycastle.operator.OperatorCreationException;
import shaded.org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import shaded.org.bouncycastle.tls.Certificate;
import shaded.org.bouncycastle.tls.crypto.TlsCertificate;
import shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCryptoProvider;
import shaded.org.bouncycastle.tls.test.TestOCSPCertServer;

public class OCSPTest
extends TestCase {
    public void setUp() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    public void testOCSPResponder() throws Exception {
        JcaTlsCrypto crypto = (JcaTlsCrypto)new JcaTlsCryptoProvider().create(new SecureRandom());
        DigestCalculator digCalc = new JcaDigestCalculatorProviderBuilder().build().get(CertificateID.HASH_SHA1);
        TestOCSPCertServer server = new TestOCSPCertServer();
        X509Certificate caCert = server.getCACert();
        X509CertificateHolder cert1 = server.issueClientCert("CN=Okay", false).getCertificate();
        X509CertificateHolder cert2 = server.issueClientCert("CN=Revoked", true).getCertificate();
        TestOCSPResponderImpl responder = new TestOCSPResponderImpl(server);
        Certificate certs = new Certificate(new TlsCertificate[]{crypto.createCertificate(cert1.getEncoded()), crypto.createCertificate(cert2.getEncoded())});
        OCSPResponse[] responses = responder.getResponses(certs);
        OCSPTest.assertEquals((int)2, (int)responses.length);
        OCSPResponse response = responses[0];
        OCSPTest.assertEquals((int)0, (int)response.getResponseStatus().getValue().intValue());
        OCSPTest.assertEquals((Object)OCSPObjectIdentifiers.id_pkix_ocsp_basic, (Object)response.getResponseBytes().getResponseType());
        BasicOCSPResp basicResp = new BasicOCSPResp(BasicOCSPResponse.getInstance(response.getResponseBytes().getResponse().getOctets()));
        SingleResp[] resps = basicResp.getResponses();
        OCSPTest.assertEquals((int)1, (int)resps.length);
        OCSPTest.assertEquals((Object)resps[0].getCertID(), (Object)new JcaCertificateID(digCalc, caCert, cert1.getSerialNumber()));
        OCSPTest.assertNull((Object)resps[0].getCertStatus());
        response = responses[1];
        OCSPTest.assertEquals((int)0, (int)response.getResponseStatus().getValue().intValue());
        OCSPTest.assertEquals((Object)OCSPObjectIdentifiers.id_pkix_ocsp_basic, (Object)response.getResponseBytes().getResponseType());
        basicResp = new BasicOCSPResp(BasicOCSPResponse.getInstance(response.getResponseBytes().getResponse().getOctets()));
        resps = basicResp.getResponses();
        OCSPTest.assertEquals((int)1, (int)resps.length);
        OCSPTest.assertEquals((Object)resps[0].getCertID(), (Object)new JcaCertificateID(digCalc, caCert, cert2.getSerialNumber()));
        OCSPTest.assertNotNull((Object)resps[0].getCertStatus());
    }

    private class TestOCSPResponderImpl
    implements OCSPResponder {
        private final TestOCSPCertServer server;
        private final DigestCalculator digCalc;
        private final X509Certificate caCert;

        public TestOCSPResponderImpl(TestOCSPCertServer server) throws OperatorCreationException {
            this.server = server;
            this.caCert = server.getCACert();
            this.digCalc = new JcaDigestCalculatorProviderBuilder().build().get(CertificateID.HASH_SHA1);
        }

        @Override
        public OCSPResponse[] getResponses(Certificate certs) throws IOException {
            TlsCertificate[] certList = certs.getCertificateList();
            ArrayList<OCSPResponse> responses = new ArrayList<OCSPResponse>();
            for (int i = 0; i != certList.length; ++i) {
                try {
                    OCSPReqBuilder reqBuilder = new OCSPReqBuilder();
                    reqBuilder.addRequest(new CertificateID(this.digCalc, new X509CertificateHolder(this.caCert.getEncoded()), certList[i].getSerialNumber()));
                    responses.add(this.server.respond(reqBuilder.build()).toASN1Structure());
                    continue;
                }
                catch (OCSPException e) {
                    throw new IOException("OCSP issue: " + e.getMessage());
                }
                catch (CertificateEncodingException e) {
                    throw new IOException("CA encoding issue: " + e.getMessage());
                }
                catch (Exception e) {
                    throw new IOException("OCSP response issue: " + e.getMessage());
                }
            }
            return responses.toArray(new OCSPResponse[responses.size()]);
        }
    }

    static interface OCSPResponder {
        public OCSPResponse[] getResponses(Certificate var1) throws IOException;
    }
}

