/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import shaded.org.bouncycastle.asn1.DERNull;
import shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.org.bouncycastle.asn1.x509.DigestInfo;
import shaded.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import shaded.org.bouncycastle.tls.TlsFatalAlert;
import shaded.org.bouncycastle.tls.TlsUtils;
import shaded.org.bouncycastle.tls.crypto.TlsSigner;
import shaded.org.bouncycastle.tls.crypto.TlsStreamSigner;
import shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaUtils;
import shaded.org.bouncycastle.tls.crypto.impl.jcajce.SignatureOutputStream;

public class JcaTlsRSASigner
implements TlsSigner {
    private final PrivateKey privateKey;
    private final JcaTlsCrypto crypto;
    private Signature rawSigner = null;

    public JcaTlsRSASigner(JcaTlsCrypto crypto, PrivateKey privateKey) {
        this.crypto = crypto;
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        this.privateKey = privateKey;
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        try {
            Signature signer = this.getRawSigner();
            if (algorithm != null) {
                if (algorithm.getSignature() != 1) {
                    throw new IllegalStateException();
                }
                AlgorithmIdentifier algID = new AlgorithmIdentifier(TlsUtils.getOIDForHashAlgorithm(algorithm.getHash()), DERNull.INSTANCE);
                byte[] digestInfo = new DigestInfo(algID, hash).getEncoded();
                signer.update(digestInfo, 0, digestInfo.length);
            } else {
                signer.update(hash, 0, hash.length);
            }
            return signer.sign();
        }
        catch (GeneralSecurityException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    @Override
    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm algorithm) throws IOException {
        if (algorithm != null && algorithm.getSignature() == 1 && JcaUtils.isSunMSCAPIProviderActive()) {
            try {
                Signature rawSigner = this.getRawSigner();
                if (JcaUtils.isSunMSCAPIProvider(rawSigner.getProvider())) {
                    String algorithmName = JcaUtils.getJcaAlgorithmName(algorithm);
                    final Signature signer = this.crypto.getHelper().createSignature(algorithmName);
                    signer.initSign(this.privateKey, this.crypto.getSecureRandom());
                    return new TlsStreamSigner(){

                        @Override
                        public OutputStream getOutputStream() {
                            return new SignatureOutputStream(signer);
                        }

                        @Override
                        public byte[] getSignature() throws IOException {
                            try {
                                return signer.sign();
                            }
                            catch (SignatureException e) {
                                throw new TlsFatalAlert(80, (Throwable)e);
                            }
                        }
                    };
                }
            }
            catch (GeneralSecurityException e) {
                throw new TlsFatalAlert(80, (Throwable)e);
            }
        }
        return null;
    }

    protected Signature getRawSigner() throws GeneralSecurityException {
        if (this.rawSigner == null) {
            this.rawSigner = this.crypto.getHelper().createSignature("NoneWithRSA");
            this.rawSigner.initSign(this.privateKey, this.crypto.getSecureRandom());
        }
        return this.rawSigner;
    }
}

