/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.interfaces.DHPublicKey;
import shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shaded.org.bouncycastle.asn1.ASN1OctetString;
import shaded.org.bouncycastle.asn1.ASN1Primitive;
import shaded.org.bouncycastle.asn1.x509.Certificate;
import shaded.org.bouncycastle.asn1.x509.Extensions;
import shaded.org.bouncycastle.asn1.x509.KeyUsage;
import shaded.org.bouncycastle.asn1.x509.TBSCertificate;
import shaded.org.bouncycastle.jcajce.util.JcaJceHelper;
import shaded.org.bouncycastle.tls.TlsFatalAlert;
import shaded.org.bouncycastle.tls.crypto.TlsCertificate;
import shaded.org.bouncycastle.tls.crypto.TlsCryptoException;
import shaded.org.bouncycastle.tls.crypto.TlsVerifier;
import shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsDSAVerifier;
import shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsECDSAVerifier;
import shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsRSAVerifier;

public class JcaTlsCertificate
implements TlsCertificate {
    protected final JcaTlsCrypto crypto;
    protected final X509Certificate certificate;
    protected DHPublicKey pubKeyDH = null;
    protected ECPublicKey pubKeyEC = null;
    protected RSAPublicKey pubKeyRSA = null;

    public static JcaTlsCertificate convert(JcaTlsCrypto crypto, TlsCertificate certificate) throws IOException {
        if (certificate instanceof JcaTlsCertificate) {
            return (JcaTlsCertificate)certificate;
        }
        return new JcaTlsCertificate(crypto, certificate.getEncoded());
    }

    public static X509Certificate parseCertificate(JcaJceHelper helper, byte[] encoding) throws IOException {
        try {
            byte[] derEncoding = Certificate.getInstance(encoding).getEncoded("DER");
            ByteArrayInputStream input = new ByteArrayInputStream(derEncoding);
            X509Certificate certificate = (X509Certificate)helper.createCertificateFactory("X.509").generateCertificate(input);
            if (input.available() != 0) {
                throw new IOException("Extra data detected in stream");
            }
            return certificate;
        }
        catch (GeneralSecurityException e) {
            throw new TlsCryptoException("unable to decode certificate", e);
        }
    }

    public JcaTlsCertificate(JcaTlsCrypto crypto, byte[] encoding) throws IOException {
        this(crypto, JcaTlsCertificate.parseCertificate(crypto.getHelper(), encoding));
    }

    public JcaTlsCertificate(JcaTlsCrypto crypto, X509Certificate certificate) {
        this.crypto = crypto;
        this.certificate = certificate;
    }

    @Override
    public TlsVerifier createVerifier(short signatureAlgorithm) throws IOException {
        this.validateKeyUsage(128);
        switch (signatureAlgorithm) {
            case 2: {
                return new JcaTlsDSAVerifier(this.getPubKeyDSS(), this.crypto.getHelper());
            }
            case 3: {
                return new JcaTlsECDSAVerifier(this.getPubKeyEC(), this.crypto.getHelper());
            }
            case 1: {
                return new JcaTlsRSAVerifier(this.getPubKeyRSA(), this.crypto.getHelper());
            }
        }
        throw new TlsFatalAlert(46);
    }

    @Override
    public short getClientCertificateType() throws IOException {
        PublicKey publicKey = this.getPublicKey();
        try {
            if (publicKey instanceof RSAPublicKey) {
                this.validateKeyUsage(128);
                return 1;
            }
            if (publicKey instanceof DSAPublicKey) {
                this.validateKeyUsage(128);
                return 2;
            }
            if (publicKey instanceof ECPublicKey) {
                this.validateKeyUsage(128);
                return 64;
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TlsFatalAlert(43, (Throwable)e);
        }
        throw new TlsFatalAlert(43);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        try {
            return this.certificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new TlsCryptoException("unable to encode certificate: " + e.getMessage(), e);
        }
    }

    @Override
    public byte[] getExtension(ASN1ObjectIdentifier extensionOID) throws IOException {
        byte[] encoding = this.certificate.getExtensionValue(extensionOID.getId());
        return encoding == null ? null : ((ASN1OctetString)ASN1Primitive.fromByteArray(encoding)).getOctets();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.certificate.getSerialNumber();
    }

    DHPublicKey getPubKeyDH() throws IOException {
        DHPublicKey pubKeyDH;
        try {
            pubKeyDH = (DHPublicKey)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
        return this.validatePubKeyDH(pubKeyDH);
    }

    DSAPublicKey getPubKeyDSS() throws IOException {
        DSAPublicKey pubKeyDSS;
        try {
            pubKeyDSS = (DSAPublicKey)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
        return this.validatePubKeyDSS(pubKeyDSS);
    }

    ECPublicKey getPubKeyEC() throws IOException {
        ECPublicKey pubKeyEC;
        try {
            pubKeyEC = (ECPublicKey)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
        return this.validatePubKeyEC(pubKeyEC);
    }

    RSAPublicKey getPubKeyRSA() throws IOException {
        RSAPublicKey pubKeyRSA;
        try {
            pubKeyRSA = (RSAPublicKey)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
        return this.validatePubKeyRSA(pubKeyRSA);
    }

    @Override
    public TlsCertificate useInRole(int connectionEnd, int keyExchangeAlgorithm) throws IOException {
        switch (keyExchangeAlgorithm) {
            case 7: 
            case 9: {
                this.validateKeyUsage(8);
                this.pubKeyDH = this.getPubKeyDH();
                return this;
            }
            case 16: 
            case 18: {
                this.validateKeyUsage(8);
                this.pubKeyEC = this.getPubKeyEC();
                return this;
            }
        }
        if (connectionEnd == 0) {
            switch (keyExchangeAlgorithm) {
                case 1: 
                case 15: {
                    this.validateKeyUsage(32);
                    this.pubKeyRSA = this.getPubKeyRSA();
                    return this;
                }
            }
        }
        throw new TlsFatalAlert(46);
    }

    protected PublicKey getPublicKey() throws IOException {
        try {
            return this.certificate.getPublicKey();
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(43, (Throwable)e);
        }
    }

    public X509Certificate getX509Certificate() {
        return this.certificate;
    }

    protected void validateKeyUsage(int keyUsageBits) throws IOException {
        int bits;
        KeyUsage ku;
        Extensions exts;
        try {
            exts = TBSCertificate.getInstance(this.certificate.getTBSCertificate()).getExtensions();
        }
        catch (CertificateEncodingException e) {
            throw new TlsCryptoException("unable to parse certificate extensions: " + e.getMessage(), e);
        }
        if (exts != null && (ku = KeyUsage.fromExtensions(exts)) != null && ((bits = ku.getBytes()[0] & 0xFF) & keyUsageBits) != keyUsageBits) {
            throw new TlsFatalAlert(46);
        }
    }

    protected DHPublicKey validatePubKeyDH(DHPublicKey pubKeyDH) throws IOException {
        return pubKeyDH;
    }

    protected DSAPublicKey validatePubKeyDSS(DSAPublicKey pubKeyDSS) throws IOException {
        return pubKeyDSS;
    }

    protected ECPublicKey validatePubKeyEC(ECPublicKey pubKeyEC) throws IOException {
        return pubKeyEC;
    }

    protected RSAPublicKey validatePubKeyRSA(RSAPublicKey pubKeyRSA) throws IOException {
        return pubKeyRSA;
    }
}

