/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls.crypto.impl.bc;

import shaded.org.bouncycastle.crypto.Digest;
import shaded.org.bouncycastle.crypto.Signer;
import shaded.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import shaded.org.bouncycastle.crypto.engines.RSABlindedEngine;
import shaded.org.bouncycastle.crypto.params.RSAKeyParameters;
import shaded.org.bouncycastle.crypto.signers.GenericSigner;
import shaded.org.bouncycastle.crypto.signers.RSADigestSigner;
import shaded.org.bouncycastle.tls.DigitallySigned;
import shaded.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import shaded.org.bouncycastle.tls.TlsUtils;
import shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;

public class BcTlsRSAVerifier
extends BcTlsVerifier {
    public BcTlsRSAVerifier(BcTlsCrypto crypto, RSAKeyParameters publicKey) {
        super(crypto, publicKey);
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned signedParams, byte[] hash) {
        Signer signer;
        Digest nullDigest = this.crypto.createDigest((short)0);
        SignatureAndHashAlgorithm algorithm = signedParams.getAlgorithm();
        if (algorithm != null) {
            if (algorithm.getSignature() != 1) {
                throw new IllegalStateException();
            }
            signer = new RSADigestSigner(nullDigest, TlsUtils.getOIDForHashAlgorithm(algorithm.getHash()));
        } else {
            signer = new GenericSigner(new PKCS1Encoding(new RSABlindedEngine()), nullDigest);
        }
        signer.init(false, this.publicKey);
        signer.update(hash, 0, hash.length);
        return signer.verifySignature(signedParams.getSignature());
    }
}

