/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import shaded.org.bouncycastle.tls.AbstractTlsPeer;
import shaded.org.bouncycastle.tls.CertificateStatusRequest;
import shaded.org.bouncycastle.tls.DefaultTlsECConfigVerifier;
import shaded.org.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import shaded.org.bouncycastle.tls.NewSessionTicket;
import shaded.org.bouncycastle.tls.OCSPStatusRequest;
import shaded.org.bouncycastle.tls.ProtocolVersion;
import shaded.org.bouncycastle.tls.ServerNameList;
import shaded.org.bouncycastle.tls.TlsClient;
import shaded.org.bouncycastle.tls.TlsClientContext;
import shaded.org.bouncycastle.tls.TlsCompression;
import shaded.org.bouncycastle.tls.TlsDHUtils;
import shaded.org.bouncycastle.tls.TlsECCUtils;
import shaded.org.bouncycastle.tls.TlsECConfigVerifier;
import shaded.org.bouncycastle.tls.TlsExtensionsUtils;
import shaded.org.bouncycastle.tls.TlsFatalAlert;
import shaded.org.bouncycastle.tls.TlsKeyExchangeFactory;
import shaded.org.bouncycastle.tls.TlsNullCompression;
import shaded.org.bouncycastle.tls.TlsSession;
import shaded.org.bouncycastle.tls.TlsUtils;
import shaded.org.bouncycastle.tls.crypto.TlsCipher;
import shaded.org.bouncycastle.tls.crypto.TlsCrypto;
import shaded.org.bouncycastle.tls.crypto.TlsCryptoParameters;

public abstract class AbstractTlsClient
extends AbstractTlsPeer
implements TlsClient {
    protected TlsKeyExchangeFactory keyExchangeFactory;
    protected TlsClientContext context;
    protected Vector supportedGroups;
    protected Vector supportedSignatureAlgorithms;
    protected short[] clientECPointFormats;
    protected short[] serverECPointFormats;
    protected int selectedCipherSuite;
    protected short selectedCompressionMethod;

    public AbstractTlsClient(TlsCrypto crypto) {
        this(crypto, new DefaultTlsKeyExchangeFactory());
    }

    public AbstractTlsClient(TlsCrypto crypto, TlsKeyExchangeFactory keyExchangeFactory) {
        super(crypto);
        this.keyExchangeFactory = keyExchangeFactory;
    }

    protected boolean allowUnexpectedServerExtension(Integer extensionType, byte[] extensionData) throws IOException {
        switch (extensionType) {
            case 10: {
                TlsExtensionsUtils.readSupportedGroupsExtension(extensionData);
                return true;
            }
            case 11: {
                TlsECCUtils.readSupportedPointFormatsExtension(extensionData);
                return true;
            }
        }
        return false;
    }

    protected void checkForUnexpectedServerExtension(Hashtable serverExtensions, Integer extensionType) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(serverExtensions, extensionType);
        if (extensionData != null && !this.allowUnexpectedServerExtension(extensionType, extensionData)) {
            throw new TlsFatalAlert(47);
        }
    }

    protected TlsECConfigVerifier createECConfigVerifier() {
        int minimumCurveBits = TlsECCUtils.getMinimumCurveBits(this.selectedCipherSuite);
        return new DefaultTlsECConfigVerifier(minimumCurveBits, this.supportedGroups);
    }

    protected CertificateStatusRequest getCertificateStatusRequest() {
        return new CertificateStatusRequest(1, new OCSPStatusRequest(null, null));
    }

    protected Vector getSNIServerNames() {
        return null;
    }

    protected short[] getSupportedPointFormats() {
        return new short[]{0, 1, 2};
    }

    protected Vector getSupportedGroups(boolean offeringDH, boolean offeringEC) {
        Vector<Integer> supportedGroups = new Vector<Integer>();
        if (offeringEC) {
            supportedGroups.addElement(23);
            supportedGroups.addElement(24);
        }
        if (offeringDH) {
            supportedGroups.addElement(256);
            supportedGroups.addElement(257);
            supportedGroups.addElement(258);
        }
        return supportedGroups;
    }

    protected Vector getSupportedSignatureAlgorithms() {
        return TlsUtils.getDefaultSupportedSignatureAlgorithms(this.context);
    }

    @Override
    public void init(TlsClientContext context) {
        this.context = context;
    }

    @Override
    public TlsSession getSessionToResume() {
        return null;
    }

    @Override
    public ProtocolVersion getClientHelloRecordLayerVersion() {
        return this.getClientVersion();
    }

    @Override
    public ProtocolVersion getClientVersion() {
        return ProtocolVersion.TLSv12;
    }

    @Override
    public boolean isFallback() {
        return false;
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        Vector supportedGroups;
        ProtocolVersion clientVersion;
        CertificateStatusRequest statusRequest;
        Vector sniServerNames;
        Hashtable clientExtensions = new Hashtable();
        TlsExtensionsUtils.addEncryptThenMACExtension(clientExtensions);
        if (!ProtocolVersion.GMTLSv11.equals(this.context.getClientVersion())) {
            TlsExtensionsUtils.addExtendedMasterSecretExtension(clientExtensions);
        }
        if ((sniServerNames = this.getSNIServerNames()) != null) {
            TlsExtensionsUtils.addServerNameExtension(clientExtensions, new ServerNameList(sniServerNames));
        }
        if ((statusRequest = this.getCertificateStatusRequest()) != null) {
            TlsExtensionsUtils.addStatusRequestExtension(clientExtensions, statusRequest);
        }
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(clientVersion = this.context.getClientVersion())) {
            this.supportedSignatureAlgorithms = this.getSupportedSignatureAlgorithms();
            TlsUtils.addSignatureAlgorithmsExtension(clientExtensions, this.supportedSignatureAlgorithms);
        }
        int[] cipherSuites = this.getCipherSuites();
        boolean offeringDH = TlsDHUtils.containsDHECipherSuites(cipherSuites);
        boolean offeringEC = TlsECCUtils.containsECCipherSuites(cipherSuites);
        if (offeringEC) {
            this.clientECPointFormats = this.getSupportedPointFormats();
            TlsECCUtils.addSupportedPointFormatsExtension(clientExtensions, this.clientECPointFormats);
        }
        if ((supportedGroups = this.getSupportedGroups(offeringDH, offeringEC)) != null && !supportedGroups.isEmpty()) {
            this.supportedGroups = supportedGroups;
            TlsExtensionsUtils.addSupportedGroupsExtension(clientExtensions, supportedGroups);
        }
        return clientExtensions;
    }

    public ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.TLSv10;
    }

    @Override
    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        if (!this.getMinimumVersion().isEqualOrEarlierVersionOf(serverVersion)) {
            throw new TlsFatalAlert(70);
        }
    }

    @Override
    public short[] getCompressionMethods() {
        return new short[]{0};
    }

    @Override
    public void notifySessionID(byte[] sessionID) {
    }

    @Override
    public void notifySelectedCipherSuite(int selectedCipherSuite) {
        this.selectedCipherSuite = selectedCipherSuite;
    }

    @Override
    public void notifySelectedCompressionMethod(short selectedCompressionMethod) {
        this.selectedCompressionMethod = selectedCompressionMethod;
    }

    @Override
    public void processServerExtensions(Hashtable serverExtensions) throws IOException {
        if (serverExtensions != null) {
            this.checkForUnexpectedServerExtension(serverExtensions, TlsUtils.EXT_signature_algorithms);
            this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_supported_groups);
            if (TlsECCUtils.isECCipherSuite(this.selectedCipherSuite)) {
                this.serverECPointFormats = TlsECCUtils.getSupportedPointFormatsExtension(serverExtensions);
            } else {
                this.checkForUnexpectedServerExtension(serverExtensions, TlsECCUtils.EXT_ec_point_formats);
            }
            this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_padding);
        }
    }

    @Override
    public void processServerSupplementalData(Vector serverSupplementalData) throws IOException {
        if (serverSupplementalData != null) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public Vector getClientSupplementalData() throws IOException {
        return null;
    }

    @Override
    public TlsCompression getCompression() throws IOException {
        switch (this.selectedCompressionMethod) {
            case 0: {
                return new TlsNullCompression();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsCipher getCipher() throws IOException {
        int encryptionAlgorithm = TlsUtils.getEncryptionAlgorithm(this.selectedCipherSuite);
        int macAlgorithm = TlsUtils.getMACAlgorithm(this.selectedCipherSuite);
        if (encryptionAlgorithm < 0 || macAlgorithm < 0) {
            throw new TlsFatalAlert(80);
        }
        return this.context.getSecurityParameters().getMasterSecret().createCipher(new TlsCryptoParameters(this.context), encryptionAlgorithm, macAlgorithm);
    }

    @Override
    public void notifyNewSessionTicket(NewSessionTicket newSessionTicket) throws IOException {
    }
}

