/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.pqc.jcajce.provider.ntruprime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;
import shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import shaded.org.bouncycastle.pqc.crypto.ntruprime.NTRULPRimePublicKeyParameters;
import shaded.org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import shaded.org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import shaded.org.bouncycastle.pqc.jcajce.interfaces.NTRULPRimeKey;
import shaded.org.bouncycastle.pqc.jcajce.spec.NTRULPRimeParameterSpec;
import shaded.org.bouncycastle.util.Arrays;

public class BCNTRULPRimePublicKey
implements PublicKey,
NTRULPRimeKey {
    private static final long serialVersionUID = 1L;
    private transient NTRULPRimePublicKeyParameters params;

    public BCNTRULPRimePublicKey(NTRULPRimePublicKeyParameters nTRULPRimePublicKeyParameters) {
        this.params = nTRULPRimePublicKeyParameters;
    }

    public BCNTRULPRimePublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.params = (NTRULPRimePublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCNTRULPRimePublicKey) {
            BCNTRULPRimePublicKey bCNTRULPRimePublicKey = (BCNTRULPRimePublicKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCNTRULPRimePublicKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return "NTRULPRime";
    }

    @Override
    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public NTRULPRimeParameterSpec getParameterSpec() {
        return NTRULPRimeParameterSpec.fromName(this.params.getParameters().getName());
    }

    NTRULPRimePublicKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

