/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.pqc.jcajce.provider.mceliece;

import java.io.IOException;
import java.security.PrivateKey;
import shaded.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shaded.org.bouncycastle.pqc.asn1.McElieceCCA2PrivateKey;
import shaded.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import shaded.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyParameters;
import shaded.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import shaded.org.bouncycastle.pqc.jcajce.provider.mceliece.Utils;
import shaded.org.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import shaded.org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import shaded.org.bouncycastle.pqc.math.linearalgebra.Permutation;
import shaded.org.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;

public class BCMcElieceCCA2PrivateKey
implements PrivateKey {
    private static final long serialVersionUID = 1L;
    private McElieceCCA2PrivateKeyParameters params;

    public BCMcElieceCCA2PrivateKey(McElieceCCA2PrivateKeyParameters mcElieceCCA2PrivateKeyParameters) {
        this.params = mcElieceCCA2PrivateKeyParameters;
    }

    @Override
    public String getAlgorithm() {
        return "McEliece-CCA2";
    }

    public int getN() {
        return ((McElieceCCA2PrivateKeyParameters)((Object)this.params)).getN();
    }

    public int getK() {
        return ((McElieceCCA2PrivateKeyParameters)((Object)this.params)).getK();
    }

    public int getT() {
        return ((McElieceCCA2PrivateKeyParameters)((Object)this.params)).getGoppaPoly().getDegree();
    }

    public GF2mField getField() {
        return ((McElieceCCA2PrivateKeyParameters)((Object)this.params)).getField();
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        return ((McElieceCCA2PrivateKeyParameters)((Object)this.params)).getGoppaPoly();
    }

    public Permutation getP() {
        return ((McElieceCCA2PrivateKeyParameters)((Object)this.params)).getP();
    }

    public GF2Matrix getH() {
        return ((McElieceCCA2PrivateKeyParameters)((Object)this.params)).getH();
    }

    public PolynomialGF2mSmallM[] getQInv() {
        return ((McElieceCCA2PrivateKeyParameters)((Object)this.params)).getQInv();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BCMcElieceCCA2PrivateKey)) {
            return false;
        }
        BCMcElieceCCA2PrivateKey bCMcElieceCCA2PrivateKey = (BCMcElieceCCA2PrivateKey)object;
        return this.getN() == bCMcElieceCCA2PrivateKey.getN() && this.getK() == bCMcElieceCCA2PrivateKey.getK() && this.getField().equals(bCMcElieceCCA2PrivateKey.getField()) && this.getGoppaPoly().equals(bCMcElieceCCA2PrivateKey.getGoppaPoly()) && this.getP().equals(bCMcElieceCCA2PrivateKey.getP()) && this.getH().equals(bCMcElieceCCA2PrivateKey.getH());
    }

    public int hashCode() {
        int n = ((McElieceCCA2PrivateKeyParameters)((Object)this.params)).getK();
        n = n * 37 + ((McElieceCCA2PrivateKeyParameters)((Object)this.params)).getN();
        n = n * 37 + ((McElieceCCA2PrivateKeyParameters)((Object)this.params)).getField().hashCode();
        n = n * 37 + ((McElieceCCA2PrivateKeyParameters)((Object)this.params)).getGoppaPoly().hashCode();
        n = n * 37 + ((McElieceCCA2PrivateKeyParameters)((Object)this.params)).getP().hashCode();
        return n * 37 + ((McElieceCCA2PrivateKeyParameters)((Object)this.params)).getH().hashCode();
    }

    @Override
    public byte[] getEncoded() {
        try {
            McElieceCCA2PrivateKey mcElieceCCA2PrivateKey = new McElieceCCA2PrivateKey(this.getN(), this.getK(), this.getField(), this.getGoppaPoly(), this.getP(), Utils.getDigAlgId((String)((McElieceCCA2KeyParameters)((Object)this.params)).getDigest()));
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.mcElieceCca2);
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, mcElieceCCA2PrivateKey);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    AsymmetricKeyParameter getKeyParams() {
        return this.params;
    }
}

