/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.pqc.jcajce.provider.cmce;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;
import shaded.org.bouncycastle.crypto.SecretWithEncapsulation;
import shaded.org.bouncycastle.jcajce.SecretKeyWithEncapsulation;
import shaded.org.bouncycastle.jcajce.spec.KEMExtractSpec;
import shaded.org.bouncycastle.jcajce.spec.KEMGenerateSpec;
import shaded.org.bouncycastle.pqc.crypto.cmce.CMCEKEMExtractor;
import shaded.org.bouncycastle.pqc.crypto.cmce.CMCEKEMGenerator;
import shaded.org.bouncycastle.pqc.jcajce.provider.cmce.BCCMCEPrivateKey;
import shaded.org.bouncycastle.pqc.jcajce.provider.cmce.BCCMCEPublicKey;
import shaded.org.bouncycastle.util.Arrays;

public class CMCEKeyGeneratorSpi
extends KeyGeneratorSpi {
    private KEMGenerateSpec genSpec;
    private SecureRandom random;
    private KEMExtractSpec extSpec;

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.random = secureRandom;
        if (algorithmParameterSpec instanceof KEMGenerateSpec) {
            this.genSpec = (KEMGenerateSpec)algorithmParameterSpec;
            this.extSpec = null;
        } else if (algorithmParameterSpec instanceof KEMExtractSpec) {
            this.genSpec = null;
            this.extSpec = (KEMExtractSpec)algorithmParameterSpec;
        } else {
            throw new InvalidAlgorithmParameterException("unknown spec");
        }
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.genSpec != null) {
            BCCMCEPublicKey bCCMCEPublicKey = (BCCMCEPublicKey)this.genSpec.getPublicKey();
            CMCEKEMGenerator cMCEKEMGenerator = new CMCEKEMGenerator(this.random);
            SecretWithEncapsulation secretWithEncapsulation = cMCEKEMGenerator.generateEncapsulated(bCCMCEPublicKey.getKeyParams());
            SecretKeyWithEncapsulation secretKeyWithEncapsulation = new SecretKeyWithEncapsulation(new SecretKeySpec(secretWithEncapsulation.getSecret(), this.genSpec.getKeyAlgorithmName()), secretWithEncapsulation.getEncapsulation());
            try {
                secretWithEncapsulation.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                throw new IllegalStateException("key cleanup failed");
            }
            return secretKeyWithEncapsulation;
        }
        BCCMCEPrivateKey bCCMCEPrivateKey = (BCCMCEPrivateKey)this.extSpec.getPrivateKey();
        CMCEKEMExtractor cMCEKEMExtractor = new CMCEKEMExtractor(bCCMCEPrivateKey.getKeyParams());
        byte[] byArray = this.extSpec.getEncapsulation();
        byte[] byArray2 = cMCEKEMExtractor.extractSecret(byArray);
        SecretKeyWithEncapsulation secretKeyWithEncapsulation = new SecretKeyWithEncapsulation(new SecretKeySpec(byArray2, this.extSpec.getKeyAlgorithmName()), byArray);
        Arrays.clear(byArray2);
        return secretKeyWithEncapsulation;
    }
}

