/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.jsse.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import shaded.org.bouncycastle.jsse.provider.PropertyUtils;
import shaded.org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import shaded.org.bouncycastle.jsse.provider.ProvSSLSessionImpl;
import shaded.org.bouncycastle.tls.SessionID;
import shaded.org.bouncycastle.tls.TlsSession;
import shaded.org.bouncycastle.tls.crypto.TlsCrypto;

class ProvSSLSessionContext
implements SSLSessionContext {
    private static final int provSessionCacheSize = PropertyUtils.getIntegerSystemProperty("javax.net.ssl.sessionCacheSize", 0, 0, Integer.MAX_VALUE);
    protected final Map<SessionID, ProvSSLSessionImpl> sessionsByID = new LinkedHashMap<SessionID, ProvSSLSessionImpl>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<SessionID, ProvSSLSessionImpl> eldest) {
            boolean shouldRemove;
            boolean bl = shouldRemove = ProvSSLSessionContext.this.sessionCacheSize > 0 && this.size() > ProvSSLSessionContext.this.sessionCacheSize;
            if (shouldRemove) {
                ProvSSLSessionContext.this.removeSessionByPeer(eldest.getValue());
            }
            return shouldRemove;
        }
    };
    protected final Map<String, ProvSSLSessionImpl> sessionsByPeer = new HashMap<String, ProvSSLSessionImpl>();
    protected final ProvSSLContextSpi sslContext;
    protected final TlsCrypto crypto;
    protected int sessionCacheSize = provSessionCacheSize;
    protected int sessionTimeoutSeconds = 86400;

    ProvSSLSessionContext(ProvSSLContextSpi sslContext, TlsCrypto crypto) {
        this.sslContext = sslContext;
        this.crypto = crypto;
    }

    ProvSSLContextSpi getSSLContext() {
        return this.sslContext;
    }

    TlsCrypto getCrypto() {
        return this.crypto;
    }

    synchronized ProvSSLSessionImpl getSessionImpl(byte[] sessionID) {
        if (sessionID == null || sessionID.length < 1) {
            return null;
        }
        return this.checkSession(this.sessionsByID.get(new SessionID(sessionID)));
    }

    synchronized ProvSSLSessionImpl getSessionImpl(String hostName, int port) {
        if (hostName == null || port < 0) {
            return null;
        }
        ProvSSLSessionImpl sslSession = this.checkSession(this.sessionsByPeer.get(ProvSSLSessionContext.makePeerKey(hostName, port)));
        if (sslSession != null) {
            this.sessionsByID.get(new SessionID(sslSession.getId()));
        }
        return sslSession;
    }

    synchronized ProvSSLSessionImpl reportSession(TlsSession tlsSession, String peerHost, int peerPort) {
        SessionID sessionID = new SessionID(tlsSession.getSessionID());
        ProvSSLSessionImpl sslSession = this.sessionsByID.get(sessionID);
        if (sslSession == null || sslSession.getTlsSession() != tlsSession) {
            sslSession = new ProvSSLSessionImpl(this, tlsSession, peerHost, peerPort);
            this.sessionsByID.put(sessionID, sslSession);
        }
        this.addSessionByPeer(sslSession);
        return sslSession;
    }

    @Override
    public synchronized Enumeration<byte[]> getIds() {
        this.removeAllExpiredSessions();
        ArrayList<byte[]> ids = new ArrayList<byte[]>(this.sessionsByID.size());
        for (SessionID sessionID : this.sessionsByID.keySet()) {
            ids.add(sessionID.getBytes());
        }
        return Collections.enumeration(ids);
    }

    @Override
    public SSLSession getSession(byte[] sessionID) {
        if (sessionID == null) {
            throw new NullPointerException("'sessionID' cannot be null");
        }
        return this.getSessionImpl(sessionID);
    }

    @Override
    public synchronized int getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    @Override
    public synchronized int getSessionTimeout() {
        return this.sessionTimeoutSeconds;
    }

    @Override
    public synchronized void setSessionCacheSize(int size) throws IllegalArgumentException {
        int currentSize;
        if (this.sessionCacheSize == size) {
            return;
        }
        if (size < 0) {
            throw new IllegalArgumentException("'size' cannot be < 0");
        }
        this.sessionCacheSize = size;
        if (this.sessionCacheSize > 0 && (currentSize = this.sessionsByID.size()) > this.sessionCacheSize) {
            Iterator<ProvSSLSessionImpl> iter = this.sessionsByID.values().iterator();
            while (iter.hasNext() && currentSize > this.sessionCacheSize) {
                ProvSSLSessionImpl sslSession = iter.next();
                iter.remove();
                this.removeSessionByPeer(sslSession);
                --currentSize;
            }
        }
    }

    @Override
    public synchronized void setSessionTimeout(int seconds) throws IllegalArgumentException {
        if (this.sessionTimeoutSeconds == seconds) {
            return;
        }
        if (seconds < 0) {
            throw new IllegalArgumentException("'seconds' cannot be < 0");
        }
        this.sessionTimeoutSeconds = seconds;
        this.removeAllExpiredSessions();
    }

    private void addSessionByPeer(ProvSSLSessionImpl sslSession) {
        if (sslSession != null && sslSession.getPeerHost() != null && sslSession.getPeerPort() >= 0) {
            String peerKey = ProvSSLSessionContext.makePeerKey(sslSession.getPeerHost(), sslSession.getPeerPort());
            this.sessionsByPeer.put(peerKey, sslSession);
        }
    }

    private ProvSSLSessionImpl checkSession(ProvSSLSessionImpl sslSession) {
        if (sslSession != null) {
            long currentTimeMillis = System.currentTimeMillis();
            this.invalidateIfExpiredBefore(sslSession, currentTimeMillis);
            if (sslSession.isValid()) {
                sslSession.accessedAt(currentTimeMillis);
                return sslSession;
            }
            this.removeSessionByID(sslSession);
            this.removeSessionByPeer(sslSession);
        }
        return null;
    }

    private void invalidateIfCreatedBefore(ProvSSLSessionImpl sslSession, long creationTimeLimit) {
        if (sslSession.getCreationTime() < creationTimeLimit) {
            sslSession.invalidate();
        }
    }

    private void invalidateIfExpiredBefore(ProvSSLSessionImpl sslSession, long expiryTimeMillis) {
        if (this.sessionTimeoutSeconds > 0) {
            long creationTimeLimit = expiryTimeMillis - 1000L * (long)this.sessionTimeoutSeconds;
            this.invalidateIfCreatedBefore(sslSession, creationTimeLimit);
        }
    }

    private void removeAllExpiredSessions() {
        if (this.sessionTimeoutSeconds == 0) {
            return;
        }
        long creationTimeLimit = System.currentTimeMillis() - 1000L * (long)this.sessionTimeoutSeconds;
        Iterator<ProvSSLSessionImpl> iter = this.sessionsByID.values().iterator();
        while (iter.hasNext()) {
            ProvSSLSessionImpl sslSession = iter.next();
            this.invalidateIfCreatedBefore(sslSession, creationTimeLimit);
            if (sslSession.isValid()) continue;
            iter.remove();
            this.removeSessionByPeer(sslSession);
        }
    }

    private boolean removeSessionByID(ProvSSLSessionImpl sslSession) {
        byte[] sessionID;
        if (sslSession != null && (sessionID = sslSession.getId()) != null & sessionID.length > 0) {
            return null != this.sessionsByID.remove(new SessionID(sessionID));
        }
        return false;
    }

    private boolean removeSessionByPeer(ProvSSLSessionImpl sslSession) {
        if (sslSession != null && sslSession.getPeerHost() != null && sslSession.getPeerPort() >= 0) {
            String peerKey = ProvSSLSessionContext.makePeerKey(sslSession.getPeerHost(), sslSession.getPeerPort());
            return null != this.sessionsByPeer.remove(peerKey);
        }
        return false;
    }

    private static String makePeerKey(String hostName, int port) {
        return (hostName + ':' + Integer.toString(port)).toLowerCase(Locale.ENGLISH);
    }
}

