/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.jsse.provider;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.KeyStoreBuilderParameters;
import javax.net.ssl.ManagerFactoryParameters;
import shaded.org.bouncycastle.jsse.provider.PropertyUtils;
import shaded.org.bouncycastle.jsse.provider.ProvX509KeyManager;
import shaded.org.bouncycastle.jsse.provider.ProvX509KeyManagerSimple;

class ProvKeyManagerFactorySpi
extends KeyManagerFactorySpi {
    private static Logger LOG = Logger.getLogger(ProvKeyManagerFactorySpi.class.getName());
    private Collection<KeyManager> keyManagers;

    ProvKeyManagerFactorySpi() {
    }

    @Override
    protected void engineInit(KeyStore ks, char[] ksPassword) throws KeyStoreException {
        try {
            if (ks == null) {
                String ksProv;
                ksPassword = null;
                String ksType = PropertyUtils.getSystemProperty("javax.net.ssl.keyStoreType");
                if (ksType == null) {
                    ksType = KeyStore.getDefaultType();
                }
                ks = (ksProv = PropertyUtils.getSystemProperty("javax.net.ssl.keyStoreProvider")) == null || ksProv.length() < 1 ? KeyStore.getInstance(ksType) : KeyStore.getInstance(ksType, ksProv);
                String ksPath = null;
                String ksPathProp = PropertyUtils.getSystemProperty("javax.net.ssl.keyStore");
                if (ksPathProp != null && new File(ksPathProp).exists()) {
                    ksPath = ksPathProp;
                    String ksPasswordProp = PropertyUtils.getSystemProperty("javax.net.ssl.keyStorePassword");
                    if (ksPasswordProp != null) {
                        ksPassword = ksPasswordProp.toCharArray();
                    }
                }
                if (ksPath == null) {
                    ks.load(null, null);
                    LOG.info("Initialized with empty key store");
                } else {
                    BufferedInputStream tsInput = new BufferedInputStream(new FileInputStream(ksPath));
                    ks.load(tsInput, ksPassword);
                    ((InputStream)tsInput).close();
                    LOG.info("Initialized with key store at path: " + ksPath);
                }
            }
            if (null == this.keyManagers) {
                this.keyManagers = new ArrayList<KeyManager>();
            }
            this.keyManagers.add(new ProvX509KeyManagerSimple(ks, ksPassword));
        }
        catch (Exception e) {
            throw new KeyStoreException("initialization failed", e);
        }
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        if (managerFactoryParameters instanceof KeyStoreBuilderParameters) {
            List<KeyStore.Builder> builders = ((KeyStoreBuilderParameters)managerFactoryParameters).getParameters();
            if (null == this.keyManagers) {
                this.keyManagers = new ArrayList<KeyManager>();
            }
            this.keyManagers.add(new ProvX509KeyManager(builders));
            return;
        }
        throw new InvalidAlgorithmParameterException("Parameters must be instance of KeyStoreBuilderParameters");
    }

    @Override
    protected KeyManager[] engineGetKeyManagers() {
        if (this.keyManagers != null) {
            KeyManager[] kms = new KeyManager[this.keyManagers.size()];
            this.keyManagers.toArray(kms);
            return kms;
        }
        throw new IllegalStateException("KeyManagerFactory not initialized");
    }
}

