/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.jsse.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import shaded.org.bouncycastle.jsse.BCSNIHostName;
import shaded.org.bouncycastle.jsse.BCSNIServerName;
import shaded.org.bouncycastle.jsse.provider.JsseUtils;

abstract class JsseUtils_8
extends JsseUtils {
    JsseUtils_8() {
    }

    static SNIHostName exportSNIServerName(BCSNIServerName serverName) {
        if (serverName == null || serverName.getType() != 0) {
            return null;
        }
        return new SNIHostName(serverName.getEncoded());
    }

    static Object exportSNIServerNames(List<BCSNIServerName> serverNames) {
        if (serverNames == null) {
            return null;
        }
        ArrayList<SNIHostName> result = new ArrayList<SNIHostName>(serverNames.size());
        for (BCSNIServerName serverName : serverNames) {
            SNIHostName exported = JsseUtils_8.exportSNIServerName(serverName);
            if (exported == null) continue;
            result.add(exported);
        }
        if (!result.isEmpty()) {
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    static BCSNIHostName importSNIServerName(SNIServerName serverName) {
        if (serverName == null || serverName.getType() != 0) {
            return null;
        }
        return new BCSNIHostName(serverName.getEncoded());
    }

    static List<BCSNIServerName> importSNIServerNames(Object getServerNamesResult) {
        if (getServerNamesResult == null) {
            return null;
        }
        List serverNames = (List)getServerNamesResult;
        ArrayList<BCSNIHostName> result = new ArrayList<BCSNIHostName>(serverNames.size());
        for (SNIServerName serverName : serverNames) {
            BCSNIHostName imported = JsseUtils_8.importSNIServerName(serverName);
            if (imported == null) continue;
            result.add(imported);
        }
        if (!result.isEmpty()) {
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }
}

