/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.jcajce.provider.drbg;

import java.security.SecureRandom;
import shaded.org.bouncycastle.crypto.prng.EntropySource;
import shaded.org.bouncycastle.crypto.prng.EntropySourceProvider;
import shaded.org.bouncycastle.jcajce.provider.drbg.IncrementalEntropySource;

class IncrementalEntropySourceProvider
implements EntropySourceProvider {
    private final SecureRandom random;
    private final boolean predictionResistant;

    public IncrementalEntropySourceProvider(SecureRandom secureRandom, boolean bl) {
        this.random = secureRandom;
        this.predictionResistant = bl;
    }

    @Override
    public EntropySource get(final int n) {
        return new IncrementalEntropySource(){
            final int numBytes;
            {
                this.numBytes = (n + 7) / 8;
            }

            @Override
            public boolean isPredictionResistant() {
                return IncrementalEntropySourceProvider.this.predictionResistant;
            }

            @Override
            public byte[] getEntropy() {
                try {
                    return this.getEntropy(0L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("initial entropy fetch interrupted");
                }
            }

            @Override
            public byte[] getEntropy(long l) throws InterruptedException {
                byte[] byArray;
                int n2;
                byte[] byArray2 = new byte[this.numBytes];
                for (n2 = 0; n2 < this.numBytes / 8; ++n2) {
                    IncrementalEntropySourceProvider.sleep(l);
                    byArray = IncrementalEntropySourceProvider.this.random.generateSeed(8);
                    System.arraycopy(byArray, 0, byArray2, n2 * 8, byArray.length);
                }
                n2 = this.numBytes - this.numBytes / 8 * 8;
                if (n2 != 0) {
                    IncrementalEntropySourceProvider.sleep(l);
                    byArray = IncrementalEntropySourceProvider.this.random.generateSeed(n2);
                    System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
                }
                return byArray2;
            }

            @Override
            public int entropySize() {
                return n;
            }
        };
    }

    private static void sleep(long l) throws InterruptedException {
        if (l != 0L) {
            Thread.sleep(l);
        }
    }
}

