/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.dvcs;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import shaded.org.bouncycastle.asn1.ASN1Encodable;
import shaded.org.bouncycastle.asn1.dvcs.CertEtcToken;
import shaded.org.bouncycastle.asn1.dvcs.DVCSRequestInformationBuilder;
import shaded.org.bouncycastle.asn1.dvcs.DVCSTime;
import shaded.org.bouncycastle.asn1.dvcs.Data;
import shaded.org.bouncycastle.asn1.dvcs.ServiceType;
import shaded.org.bouncycastle.asn1.dvcs.TargetEtcChain;
import shaded.org.bouncycastle.asn1.x509.Extension;
import shaded.org.bouncycastle.cert.X509CertificateHolder;
import shaded.org.bouncycastle.dvcs.DVCSException;
import shaded.org.bouncycastle.dvcs.DVCSRequest;
import shaded.org.bouncycastle.dvcs.DVCSRequestBuilder;
import shaded.org.bouncycastle.dvcs.TargetChain;

public class VPKCRequestBuilder
extends DVCSRequestBuilder {
    private List chains = new ArrayList();

    public VPKCRequestBuilder() {
        super(new DVCSRequestInformationBuilder(ServiceType.VPKC));
    }

    public void addTargetChain(X509CertificateHolder x509CertificateHolder) {
        this.chains.add(new TargetEtcChain(new CertEtcToken(0, (ASN1Encodable)x509CertificateHolder.toASN1Structure())));
    }

    public void addTargetChain(Extension extension) {
        this.chains.add(new TargetEtcChain(new CertEtcToken(extension)));
    }

    public void addTargetChain(TargetChain targetChain) {
        this.chains.add(targetChain.toASN1Structure());
    }

    public void setRequestTime(Date date) {
        this.requestInformationBuilder.setRequestTime(new DVCSTime(date));
    }

    public DVCSRequest build() throws DVCSException {
        Data data = new Data(this.chains.toArray(new TargetEtcChain[this.chains.size()]));
        return this.createDVCRequest(data);
    }
}

