/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.crypto.generators;

import java.security.SecureRandom;
import shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import shaded.org.bouncycastle.crypto.CryptoServicePurpose;
import shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import shaded.org.bouncycastle.crypto.KeyGenerationParameters;
import shaded.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import shaded.org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import shaded.org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;

public class Ed25519KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("Ed25519KeyGen", 128, null, CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        Ed25519PrivateKeyParameters ed25519PrivateKeyParameters = new Ed25519PrivateKeyParameters(this.random);
        Ed25519PublicKeyParameters ed25519PublicKeyParameters = ed25519PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(ed25519PublicKeyParameters, ed25519PrivateKeyParameters);
    }
}

